/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Remove
extends SubCommand {
    public Remove() {
        EmptyCommand emptyTPortPlayer = new EmptyCommand();
        emptyTPortPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyTPortPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.remove.tportName.player.commandDescription", new Object[0]));
        emptyTPortPlayer.setTabRunnable((args, player) -> {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                return Collections.emptyList();
            }
            List list = tport.getLogged().stream().map(PlayerUUID::getPlayerName).collect(Collectors.toList());
            list.removeAll(Arrays.asList(args).subList(3, args.length));
            return list;
        });
        emptyTPortPlayer.setLooped(true);
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setTabRunnable(emptyTPortPlayer.getTabRunnable());
        emptyTPort.addAction(emptyTPortPlayer);
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().filter(TPort::isLogged).map(TPort::getName).collect(Collectors.toList());
    }

    public static void run(Player player, TPort tport, String playerName, boolean sendError) {
        UUID playerUUID = PlayerUUID.getPlayerUUID(playerName, player);
        if (playerUUID == null) {
            return;
        }
        if (tport.removeLogged(playerUUID)) {
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.remove.tportName.player.succeeded", PlayerEncapsulation.asPlayer(playerUUID));
            ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)playerUUID), "tport.command.log.remove.tportName.player.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
        } else if (sendError) {
            ColorTheme.sendErrorTranslation(player, "tport.command.log.remove.tportName.player.playerNotLogged", PlayerEncapsulation.asPlayer(playerUUID));
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log remove <TPort name> <player...>");
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
            return;
        }
        for (int i = 3; i < args.length; ++i) {
            String playerName = args[i];
            Remove.run(player, tport, playerName, true);
        }
        tport.save();
    }
}

