/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Own;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Notify
extends SubCommand {
    private final EmptyCommand emptyTPortState = new EmptyCommand();

    public Notify() {
        this.emptyTPortState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyTPortState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.notify.tportName.state.commandDescription", new Object[0]));
        this.emptyTPortState.setPermissions("TPort.notify.set", "TPort.basic");
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.notify.tportName.commandDescription", new Object[0]));
        emptyTPort.setTabRunnable((args, player) -> Arrays.stream(TPort.NotifyMode.values()).map(Enum::name).collect(Collectors.toList()));
        emptyTPort.addAction(this.emptyTPortState);
        this.addAction(emptyTPort);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.notify.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Own.getOwnTPorts(player);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            boolean color = true;
            Message tportsMessage = new Message();
            ArrayList<TPort> tportList = TPortManager.getTPortList(player.getUniqueId());
            int notifySize = 0;
            int notifyMax = (int)tportList.stream().filter(tport -> tport.getNotifyMode() != TPort.NotifyMode.NONE).count();
            for (TPort tport2 : tportList) {
                if (tport2.getNotifyMode() == TPort.NotifyMode.NONE) continue;
                if (color) {
                    tportsMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", TPortEncapsulation.asTPort(tport2)));
                } else {
                    tportsMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", TPortEncapsulation.asTPort(tport2)));
                }
                if (notifySize + 2 == notifyMax) {
                    tportsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.notify.lastDelimiter", new Object[0]));
                } else {
                    tportsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.notify.delimiter", new Object[0]));
                }
                color = !color;
                ++notifySize;
            }
            tportsMessage.removeLast();
            color = true;
            Message statesMessage = new Message();
            TPort.NotifyMode[] values = TPort.NotifyMode.values();
            int valuesLength = values.length;
            for (int i = 0; i < valuesLength; ++i) {
                TPort.NotifyMode notifyMode = values[i];
                if (color) {
                    statesMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", notifyMode));
                } else {
                    statesMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", notifyMode));
                }
                if (i + 2 == valuesLength) {
                    statesMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.notify.lastDelimiter", new Object[0]));
                } else {
                    statesMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.notify.delimiter", new Object[0]));
                }
                color = !color;
            }
            statesMessage.removeLast();
            if (notifySize == 0) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.notify.succeeded.none", statesMessage);
            } else if (notifySize == 1) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.notify.succeeded.singular", tportsMessage, statesMessage);
            } else {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.notify.succeeded.multiple", tportsMessage, statesMessage);
            }
        } else if (args.length == 3) {
            TPort tport3 = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport3 != null) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.notify.tportName.succeeded", TPortEncapsulation.asTPort(tport3), tport3.getNotifyMode());
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
            }
        } else if (args.length == 4) {
            if (!this.emptyTPortState.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport4 = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport4 == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            TPort.NotifyMode notify = TPort.NotifyMode.get(args[3]);
            tport4.setNotifyMode(notify);
            tport4.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.notify.tportName.state.succeeded", TPortEncapsulation.asTPort(tport4), tport4.getNotifyMode());
            TPortAdvancement.Advancement_safetyFirst.grant(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log notify [TPort name] [state]");
        }
    }
}

