/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Own;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Default
extends SubCommand {
    private final EmptyCommand emptyTPortMode = new EmptyCommand();

    public Default() {
        this.emptyTPortMode.setCommandName("default LogMode", ArgumentType.OPTIONAL);
        this.emptyTPortMode.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.default.tportName.defaultMode.commandDescription", new Object[0]));
        this.emptyTPortMode.setPermissions("TPort.log");
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.default.tportName.commandDescription", new Object[0]));
        emptyTPort.setTabRunnable((args, player) -> this.emptyTPortMode.hasPermissionToRun(player, false) ? (Collection)Arrays.stream(TPort.LogMode.values()).map(Enum::name).collect(Collectors.toList()) : Collections.emptyList());
        emptyTPort.addAction(this.emptyTPortMode);
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyTPortMode.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Own.getOwnTPorts(player);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport != null) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.default.tportName.succeeded", TPortEncapsulation.asTPort(tport), tport.getDefaultLogMode());
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
            }
        } else if (args.length == 4) {
            if (!this.emptyTPortMode.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            tport.setDefaultLogMode(TPort.LogMode.get(args[3]));
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.default.tportName.defaultMode.succeeded", TPortEncapsulation.asTPort(tport), tport.getDefaultLogMode());
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log default <TPort name> [default LogMode]");
        }
    }
}

