/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Own;
import com.spaceman.tport.fancyMessage.Attribute;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Add
extends SubCommand {
    private final EmptyCommand emptyTPortPlayer = new EmptyCommand();

    public Add() {
        this.emptyTPortPlayer.setCommandName("player:[LogMode]", ArgumentType.REQUIRED);
        this.emptyTPortPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.add.tportName.player.commandDescription", new Message(TextComponent.textComponent("/tport log add ", ColorTheme.ColorType.varInfoColor), TextComponent.textComponent("home The_Spaceman:ONLINE", ColorTheme.ColorType.varInfoColor, Attribute.ITALIC))));
        this.emptyTPortPlayer.setPermissions("TPort.log");
        this.emptyTPortPlayer.setTabRunnable((args, player) -> {
            if (!this.emptyTPortPlayer.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            Pair<String, UUID> playerProfile = PlayerUUID.getProfile(args[args.length - 1].split(":")[0], null);
            if (playerProfile.getLeft() != null) {
                String playerName = args[args.length - 1].split(":")[0];
                for (String ss : Arrays.asList(args).subList(3, args.length - 1)) {
                    if (!ss.split(":")[0].equalsIgnoreCase(playerName)) continue;
                    return Collections.emptyList();
                }
                ArrayList<CallSite> list = new ArrayList<CallSite>();
                for (TPort.LogMode mode : TPort.LogMode.values()) {
                    list.add((CallSite)((Object)(playerName + ":" + mode.name())));
                }
                return list;
            }
            ArrayList<String> newTabList = PlayerUUID.getPlayerNames();
            for (int i = 0; i < newTabList.size(); ++i) {
                String newTabElement = (String)newTabList.get(i);
                for (int j = 3; j < args.length - 1; ++j) {
                    String oldTabElement = args[j];
                    if (!oldTabElement.split(":")[0].equalsIgnoreCase(newTabElement.split(":")[0])) continue;
                    newTabList.remove(newTabElement);
                    --i;
                }
            }
            return newTabList;
        });
        this.emptyTPortPlayer.setLooped(true);
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setTabRunnable(this.emptyTPortPlayer.getTabRunnable());
        emptyTPort.addAction(this.emptyTPortPlayer);
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyTPortPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Own.getOwnTPorts(player);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log add <TPort name> <player[:LogMode]...>");
            return;
        }
        if (!this.emptyTPortPlayer.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
            return;
        }
        for (int i = 3; i < args.length; ++i) {
            UUID playerUUID;
            String playerName = args[i];
            TPort.LogMode logMode = TPort.LogMode.ALL;
            if (Pattern.matches(".*:.*", playerName)) {
                String[] split = playerName.split(":");
                logMode = TPort.LogMode.get(split[1], null);
                if (logMode == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.log.add.tportName.player.logModeNotFound", split[1]);
                    continue;
                }
                playerName = split[0];
            }
            if ((playerUUID = PlayerUUID.getPlayerUUID(playerName, player)) == null) continue;
            if (playerName.equalsIgnoreCase(player.getName())) {
                if (logMode.equals(TPort.LogMode.ALL) || logMode.equals(TPort.LogMode.ONLINE)) {
                    tport.addLogged(player.getUniqueId(), TPort.LogMode.ALL);
                    ColorTheme.sendInfoTranslation(player, "tport.command.log.add.tportName.player.addYourself", new Object[0]);
                } else if (logMode.equals(TPort.LogMode.NONE) || logMode.equals(TPort.LogMode.OFFLINE)) {
                    tport.removeLogged(player.getUniqueId());
                    ColorTheme.sendInfoTranslation(player, "tport.command.log.add.tportName.player.removeYourself", new Object[0]);
                }
                TPortAdvancement.Advancement_ImWatchingMe.grant(player);
                continue;
            }
            tport.addLogged(playerUUID, logMode);
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.add.tportName.player.succeeded", PlayerEncapsulation.asPlayer(playerUUID), logMode, TPortEncapsulation.asTPort(tport));
            TPortAdvancement.Advancement_ImWatchingYou.grant(player);
            ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)playerUUID), "tport.command.log.add.tportName.player.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport), logMode);
        }
        tport.save();
    }
}

