/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.home;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Home;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Set
extends SubCommand {
    EmptyCommand emptySetPlayerTPort = new EmptyCommand();

    public Set() {
        this.emptySetPlayerTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        this.emptySetPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.home.set.player.tportName.commandDescription", new Object[0]));
        this.emptySetPlayerTPort.setPermissions("TPort.home.set", "TPort.basic");
        EmptyCommand emptySetPlayer = new EmptyCommand();
        emptySetPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        emptySetPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.home.set.player.commandDescription", new Object[0]));
        emptySetPlayer.setTabRunnable((args, player) -> {
            UUID argOneUUID = PlayerUUID.getPlayerUUID(args[2]);
            if (argOneUUID == null) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (TPort tport : TPortManager.getTPortList(argOneUUID)) {
                Boolean access = tport.hasAccess(player.getUniqueId());
                if (access != null && !access.booleanValue()) continue;
                list.add(tport.getName());
            }
            return list;
        });
        emptySetPlayer.addAction(this.emptySetPlayerTPort);
        emptySetPlayer.setPermissions(this.emptySetPlayerTPort.getPermissions());
        this.addAction(emptySetPlayer);
        this.setPermissions(this.emptySetPlayerTPort.getPermissions());
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.home.set.commandDescription", new Object[0]));
    }

    public List<String> tabList(Player player, String[] args) {
        return PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (!this.emptySetPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            TPortInventories.openHomeEditGUI(player);
        } else if (args.length == 3) {
            if (!this.emptySetPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            String newPlayerName = args[2];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            TPortInventories.openHomeEdit_SelectTPortGUI(newPlayerUUID, player);
        } else if (args.length == 4) {
            if (!this.emptySetPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            String newPlayerName = args[2];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            TPort tport = TPortManager.getTPort(newPlayerUUID, args[3]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[3]);
                return;
            }
            Home.setHome(player, tport);
            ColorTheme.sendSuccessTranslation(player, "tport.command.home.set.player.tportName.succeeded", TPortEncapsulation.asTPort(tport));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport home set [player] [TPort]");
        }
    }
}

