/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.history;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.TeleportHistory;
import org.bukkit.entity.Player;

public class Size
extends SubCommand {
    private final EmptyCommand emptySize = new EmptyCommand();

    public Size() {
        this.emptySize.setCommandName("size", ArgumentType.OPTIONAL);
        this.emptySize.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.size.size.commandDescription", new Object[0]));
        this.emptySize.setPermissions("tport.history.size", "tport.admin");
        this.addAction(this.emptySize);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.size.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.history.size.succeeded", TeleportHistory.getHistorySize());
        } else if (args.length == 3) {
            int size;
            if (this.emptySize.hasPermissionToRun(player, true)) {
                return;
            }
            try {
                size = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.size.size.notAValidNumber", new Object[0]);
                return;
            }
            if (size < 0) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.size.size.smallerThan0", new Object[0]);
            } else if (size == 0) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.size.size.disable", "/tport features History state false");
            }
            TeleportHistory.setHistorySize(size);
            ColorTheme.sendSuccessTranslation(player, "tport.command.history.size.size.succeeded", TeleportHistory.getHistorySize());
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport history size [size]");
        }
    }
}

