/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.featureTP;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Back;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.featureTP.Mode;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.FeatureEncapsulation;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.FeatureLocationSource;
import com.spaceman.tport.metrics.FeatureSearchCounter;
import com.spaceman.tport.permissions.PermissionHandler;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Search
extends SubCommand {
    public Search() {
        EmptyCommand emptySearchFeature = new EmptyCommand();
        EmptyCommand emptySearchModeFeature = new EmptyCommand();
        emptySearchFeature.setPermissions("TPort.featureTP.type.<feature>");
        emptySearchModeFeature.setCommandName("feature", ArgumentType.REQUIRED);
        emptySearchModeFeature.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.featureTP.search.mode.feature.commandDescription", new Object[0]));
        ArrayList<String> permissions = new ArrayList<String>(emptySearchFeature.getPermissions());
        permissions.add(Mode.worldSearchString);
        emptySearchModeFeature.setPermissions(permissions);
        emptySearchModeFeature.permissionsOR(false);
        emptySearchModeFeature.setTabRunnable((args, player) -> {
            ArrayList<String> list = new ArrayList<String>(FeatureTP.getFeatures(player.getWorld()));
            FeatureTP.getTags(player.getWorld()).stream().map(Pair::getLeft).forEach(list::add);
            List<String> featureList = Arrays.asList(args).subList(2, args.length).stream().map(String::toLowerCase).toList();
            return list.stream().filter(name -> featureList.stream().noneMatch(name::equalsIgnoreCase)).toList();
        });
        emptySearchModeFeature.setLooped(true);
        EmptyCommand emptySearchMode = new EmptyCommand();
        emptySearchMode.setCommandName("mode", ArgumentType.REQUIRED);
        emptySearchMode.addAction(emptySearchModeFeature);
        emptySearchFeature.setCommandName("feature", ArgumentType.REQUIRED);
        emptySearchFeature.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.featureTP.search.feature.commandDescription", new Object[0]));
        emptySearchFeature.setTabRunnable(emptySearchModeFeature.getTabRunnable());
        emptySearchFeature.setLooped(true);
        this.addAction(emptySearchMode);
        this.addAction(emptySearchFeature);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>(FeatureTP.getFeatures(player.getWorld()));
        FeatureTP.getTags(player.getWorld()).stream().map(Pair::getLeft).forEach(list::add);
        Arrays.stream(Mode.WorldSearchMode.values()).map(Enum::name).forEach(list::add);
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 2) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport featureTP search [mode] <feature...>");
            return;
        }
        int startArgumentAt = 3;
        Mode.WorldSearchMode mode = Mode.WorldSearchMode.getForPlayer(args[2].toUpperCase(), player, true);
        if (mode == null) {
            mode = Mode.getDefMode(player.getUniqueId());
            --startArgumentAt;
        }
        List<String> features = FeatureTP.getFeatures(player.getWorld());
        List<Pair<String, List<String>>> tags = FeatureTP.getTags(player.getWorld());
        ArrayList<String> selectedFeatures = new ArrayList<String>(args.length - 2);
        block0: for (int i = startArgumentAt; i < args.length; ++i) {
            Object argument = args[i].toLowerCase();
            if (((String)argument).charAt(0) == '#') {
                if (((String)argument).startsWith("#minecraft:")) {
                    argument = "#" + ((String)argument).substring(11);
                }
                for (Pair pair : tags) {
                    if (!((String)pair.getLeft()).equals(argument)) continue;
                    for (String feature : (List)pair.getRight()) {
                        if (selectedFeatures.contains(feature)) {
                            ColorTheme.sendInfoTranslation(player, "tport.command.featureTP.search.tag.featureAlreadySelected", pair.getLeft(), feature);
                            continue;
                        }
                        if (!PermissionHandler.hasPermission(player, true, "TPort.featureTP.type." + feature)) continue;
                        selectedFeatures.add(feature);
                        TPortAdvancement.Advancement_FeatureTP_OneIsNotEnough.grant(player);
                    }
                    continue block0;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.tag.tagNotExist", argument);
                continue;
            }
            if (((String)argument).startsWith("minecraft:")) {
                argument = ((String)argument).substring(10);
            }
            for (String string : features) {
                if (!string.equals(argument)) continue;
                if (selectedFeatures.contains(string)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureAlreadySelected", string);
                    continue block0;
                }
                if (!PermissionHandler.hasPermission(player, true, "TPort.featureTP.type." + string)) continue block0;
                selectedFeatures.add(string);
                continue block0;
            }
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureNotExist", argument);
        }
        Search.featureTP(player, mode, selectedFeatures);
    }

    private static Message featuresToMessageInfo(List<String> features) {
        Message featureList = new Message();
        int listSize = features.size();
        boolean color = true;
        for (int i = 0; i < listSize; ++i) {
            String feature = features.get(i).toLowerCase();
            if (color) {
                featureList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new FeatureEncapsulation(feature)));
            } else {
                featureList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", new FeatureEncapsulation(feature)));
            }
            if (i + 2 == listSize) {
                featureList.addMessage(ColorTheme.formatInfoTranslation("tport.command.featureTP.listFeatures.info.lastDelimiter", new Object[0]));
            } else {
                featureList.addMessage(ColorTheme.formatInfoTranslation("tport.command.featureTP.listFeatures.info.delimiter", new Object[0]));
            }
            color = !color;
        }
        featureList.removeLast();
        return featureList;
    }

    public static Message featuresToMessageError(List<String> features) {
        Message featureList = new Message();
        int listSize = features.size();
        boolean color = true;
        for (int i = 0; i < listSize; ++i) {
            String feature = features.get(i).toLowerCase();
            if (color) {
                featureList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varErrorColor, "%s", new FeatureEncapsulation(feature)));
            } else {
                featureList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varError2Color, ColorTheme.ColorType.varError2Color, "%s", new FeatureEncapsulation(feature)));
            }
            if (i + 2 == listSize) {
                featureList.addMessage(ColorTheme.formatErrorTranslation("tport.command.featureTP.listFeatures.error.lastDelimiter", new Object[0]));
            } else {
                featureList.addMessage(ColorTheme.formatErrorTranslation("tport.command.featureTP.listFeatures.error.delimiter", new Object[0]));
            }
            color = !color;
        }
        featureList.removeLast();
        return featureList;
    }

    public static void featureTP(Player player, Mode.WorldSearchMode mode, List<String> features) {
        FeatureSearchCounter.add(features);
        Location startLocation = mode.getLoc(player);
        if (features.size() == 1) {
            ColorTheme.sendInfoTranslation(player, "tport.command.featureTP.search.feature.starting.singular", Search.featuresToMessageInfo(features));
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.featureTP.search.feature.starting.multiple", Search.featuresToMessageInfo(features));
        }
        Pair<Location, String> featureLoc = Search.searchFeature(player, startLocation, features);
        if (featureLoc == null) {
            if (features.size() == 1) {
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureNotFound.singular", Search.featuresToMessageError(features));
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureNotFound.multiple", Search.featuresToMessageError(features));
            }
        } else {
            Location loc = featureLoc.getLeft();
            loc = FeatureTP.setSafeY(player.getWorld(), loc.getBlockX(), loc.getBlockZ());
            if (loc != null) {
                loc.add(0.5, 0.1, 0.5);
                loc.setPitch(player.getLocation().getPitch());
                loc.setYaw(player.getLocation().getYaw());
                Back.prevTPorts.put(player.getUniqueId(), new Back.PrevTPort(Back.PrevType.FEATURE, "featureLoc", (Object)loc, "prevLoc", (Object)player.getLocation(), "featureName", (Object)featureLoc.getRight()));
                TeleportHistory.setLocationSource(player.getUniqueId(), new FeatureLocationSource(featureLoc.getRight()));
                TPEManager.requestTeleportPlayer(player, loc, () -> {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.featureTP.search.feature.succeeded", new FeatureEncapsulation((String)featureLoc.getRight()));
                    if (features.size() == 1) {
                        TPortAdvancement.Advancement_FeatureTP_Certainty.grant(player);
                    } else {
                        TPortAdvancement.Advancement_FeatureTP_Surprise.grant(player);
                    }
                }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.featureTP.search.feature.tpRequested", new FeatureEncapsulation((String)featureLoc.getRight()), delay, tickMessage, seconds, secondMessage));
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.noSafeLocation", new Object[0]);
            }
            CooldownManager.FeatureTP.update(player);
        }
    }

    public static Pair<Location, String> searchFeature(Player player, Location startLocation, List<String> features) {
        try {
            return Main.getInstance().adapter.searchFeature(player, startLocation, features);
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("FeatureTP search", false);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            return null;
        }
    }
}

