/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.featureTP;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Mode
extends SubCommand {
    public static String worldSearchString = "TPort.worldSearch.mode.<mode>";

    public Mode() {
        EmptyCommand emptyModeMode = new EmptyCommand();
        emptyModeMode.setCommandName("mode", ArgumentType.OPTIONAL);
        emptyModeMode.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.featureTP.mode.mode.commandDescription", new Object[0]));
        emptyModeMode.setPermissions(worldSearchString);
        this.addAction(emptyModeMode);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.featureTP.mode.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Arrays.stream(WorldSearchMode.values()).map(Enum::name).collect(Collectors.toList());
    }

    public static WorldSearchMode getDefMode(UUID uuid) {
        return WorldSearchMode.valueOf(Files.tportConfig.getConfig().getString("featureTP.defaultMode." + uuid.toString(), "CLOSEST"));
    }

    public static void setDefMode(UUID uuid, WorldSearchMode mode) {
        Files.tportConfig.getConfig().set("featureTP.defaultMode." + uuid.toString(), (Object)mode.name());
        Files.tportConfig.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.featureTP.mode.succeeded", Mode.getDefMode(player.getUniqueId()).name());
        } else if (args.length == 3) {
            try {
                WorldSearchMode mode = WorldSearchMode.valueOf(args[2].toUpperCase());
                if (!PermissionHandler.hasPermission(player, true, mode.getPerm())) {
                    return;
                }
                Mode.setDefMode(player.getUniqueId(), mode);
                ColorTheme.sendSuccessTranslation(player, "tport.command.featureTP.mode.mode.succeeded", mode.name());
            }
            catch (IllegalArgumentException iae) {
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.mode.mode.modeNotExist", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport featureTP mode [mode]");
        }
    }

    public static enum WorldSearchMode {
        RANDOM(Main::getRandomLocation),
        CLOSEST(Main::getClosestLocation);

        private final LocationGetter locationGetter;

        private WorldSearchMode(LocationGetter locationGetter) {
            this.locationGetter = locationGetter;
        }

        public Location getLoc(Player player) {
            return this.locationGetter.getLoc(player);
        }

        public String getPerm() {
            return "TPort.worldSearch.mode." + this.name();
        }

        public WorldSearchMode getNext() {
            boolean next = false;
            for (WorldSearchMode mode : WorldSearchMode.values()) {
                if (mode.equals((Object)this)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return mode;
            }
            return Arrays.asList(WorldSearchMode.values()).get(0);
        }

        @Nullable
        public static WorldSearchMode getForPlayer(String name, Player player, boolean checkPerm) {
            for (WorldSearchMode mode : WorldSearchMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                if (checkPerm && !PermissionHandler.hasPermission(player, true, mode.getPerm())) break;
                return mode;
            }
            return null;
        }

        @FunctionalInterface
        private static interface LocationGetter {
            public Location getLoc(Player var1);
        }
    }
}

