/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.whitelist;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Visibility
extends SubCommand {
    private final EmptyCommand emptyState = new EmptyCommand();

    private Message getEmptyCommandDescription() {
        Message message = ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.visibility.state.commandDescription", new Object[0]);
        for (TPort.WhitelistVisibility states : TPort.WhitelistVisibility.values()) {
            message.addText(TextComponent.textComponent("\n"));
            message.addMessage(states.getDescription());
        }
        return message;
    }

    public Visibility() {
        this.emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyState.setCommandDescription(this.getEmptyCommandDescription());
        this.emptyState.setPermissions("TPort.edit.whitelist.visibility", "TPort.basic");
        this.addAction(this.emptyState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.visibility.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.stream(TPort.WhitelistVisibility.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            Message hereMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.edit.private.here", new Object[0]);
            hereMessage.getText().forEach(text -> text.setInsertion("/tport help tport edit <tport name> whitelist visibility <state>").addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent("/tport help tport edit <tport name> whitelist visibility <state>", ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.runCommand("/tport help tport edit <tport name> whitelist visibility <state>")));
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.whitelist.visibility.succeeded", tport, tport.getWhitelistVisibility(), hereMessage);
        } else if (args.length == 5) {
            TPort.WhitelistVisibility visibility;
            if (!this.emptyState.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            try {
                visibility = TPort.WhitelistVisibility.valueOf(args[4].toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.visibility.state.stateNotFound", args[4]);
                return;
            }
            tport.setWhitelistVisibility(visibility);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.whitelist.visibility.state.succeeded", tport, visibility);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> whitelist visibility [state]");
        }
    }
}

