/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.whitelist;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Remove
extends SubCommand {
    public Remove() {
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.remove.commandDescription", new Object[0]));
        emptyPlayer.setTabRunnable((args, player) -> {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport != null) {
                List list = tport.getWhitelist().stream().map(PlayerUUID::getPlayerName).collect(Collectors.toList());
                list.removeAll(Arrays.asList(args).subList(4, args.length - 1));
                return list;
            }
            return new ArrayList();
        });
        emptyPlayer.setLooped(true);
        this.addAction(emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return this.getActions().get(0).tabList(player, args);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> whitelist remove <player...>");
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.remove.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        for (int i = 4; i < args.length; ++i) {
            String newPlayerName = args[i];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) continue;
            Player newPlayer = Bukkit.getPlayer((UUID)newPlayerUUID);
            if (tport.removeWhitelist(newPlayerUUID)) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.whitelist.remove.succeeded", PlayerEncapsulation.asPlayer(newPlayer, newPlayerUUID), tport);
                ColorTheme.sendInfoTranslation(newPlayer, "tport.command.edit.whitelist.remove.succeededOtherPlayer", player, tport);
                continue;
            }
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.remove.notInList", PlayerEncapsulation.asPlayer(newPlayer, newPlayerUUID), tport);
        }
        tport.save();
    }
}

