/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.tag;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.permissions.PermissionHandler;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Add
extends SubCommand {
    public Add() {
        EmptyCommand emptyTag = new EmptyCommand();
        emptyTag.setCommandName("tag", ArgumentType.REQUIRED);
        emptyTag.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.tag.add.commandDescription", new Object[0]));
        emptyTag.setPermissions("TPort.tags.type.<tag>");
        this.addAction(emptyTag);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = Tag.getTags();
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport != null) {
            list.removeAll(tport.getTags());
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 5) {
            String tag = Tag.getTag(args[4]);
            if (tag == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.tag.add.tagNotFound", args[4]);
                return;
            }
            if (!PermissionHandler.hasPermission(player, false, "TPort.tags.type." + tag)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.tag.add.noPermissionToUseTag", "TPort.tags.type." + tag, tag);
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.tag.add.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            if (tport.addTag(tag)) {
                tport.save();
                TPortAdvancement.Advancement_TaggedYoureIt.grant(player);
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.tag.add.succeeded", tag, tport);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.tag.add.hasAlreadyTag", tag, tport);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> tag add <tag>");
        }
    }
}

