/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.description;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class Set
extends SubCommand {
    private final EmptyCommand emptySetDescription = new EmptyCommand();

    public Set() {
        this.emptySetDescription.setCommandName("description", ArgumentType.REQUIRED);
        this.emptySetDescription.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.description.set.commandDescription", "\\n", "&", "0-9,a-f,k-o,r", "#123456", "$RRR$GGG$BBB"));
        this.emptySetDescription.setPermissions("TPort.edit.description", "TPort.basic");
        this.emptySetDescription.setLooped(true);
        this.addAction(this.emptySetDescription);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 4) {
            if (!this.emptySetDescription.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.description.set.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            String newDescription = StringUtils.join((Object[])args, (String)" ", (int)4, (int)args.length);
            tport.setDescription(newDescription);
            tport.save();
            Message description = tport.getDescription();
            String textDescription = tport.getRawDescription();
            Message hoverText = ColorTheme.formatInfoTranslation("tport.command.edit.description.set.literal", textDescription);
            description.getText().forEach(m -> m.addTextEvent(new HoverEvent(hoverText)).setInsertion(textDescription));
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.description.set.succeeded", tport, description);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> description set <description...>");
        }
    }
}

