/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Preview
extends SubCommand {
    private final EmptyCommand emptyPreviewState = new EmptyCommand();

    public Preview() {
        this.emptyPreviewState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyPreviewState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.preview.state.commandDescription", new Object[0]));
        this.emptyPreviewState.setPermissions("TPort.edit.preview", "TPort.basic");
        this.addAction(this.emptyPreviewState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.preview.commandDescription", new Object[0]));
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyPreviewState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.stream(TPort.PreviewState.values()).map(s -> s.name().toLowerCase()).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.Preview.isDisabled()) {
            Features.Feature.Preview.sendDisabledMessage(player);
            return;
        }
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.preview.succeeded", TPortEncapsulation.asTPort(tport), tport.getPreviewState());
        } else if (args.length == 4) {
            if (!this.emptyPreviewState.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.preview.state.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            TPort.PreviewState previewState = TPort.PreviewState.get(args[3], null);
            if (previewState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.preview.state.stateNotFound", args[3]);
                return;
            }
            if (tport.isPublicTPort() && !previewState.canGoPublic()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.preview.state.isPublic", TPortEncapsulation.asTPort(tport), previewState);
                return;
            }
            tport.setPreviewState(previewState);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.preview.state.succeeded", TPortEncapsulation.asTPort(tport), previewState);
            TPortAdvancement.Advancement_safetyFirst.grant(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> preview [state]");
        }
    }
}

