/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.publc.ListSize;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Name
extends SubCommand {
    private final EmptyCommand emptyName = new EmptyCommand();

    public Name() {
        this.emptyName.setCommandName("new TPort name", ArgumentType.REQUIRED);
        this.emptyName.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.name.commandDescription", new Object[0]));
        this.emptyName.setPermissions("TPort.edit.name", "TPort.basic");
        this.addAction(this.emptyName);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> name <new TPort name>");
            return;
        }
        if (!this.emptyName.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        TPort nameDuplicationTPort = TPortManager.getTPort(player.getUniqueId(), args[3]);
        if (nameDuplicationTPort != null) {
            if (args[3].equals(tport.getName())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.sameName", TPortEncapsulation.asTPort(tport), args[3]);
                return;
            }
            if (!args[3].equalsIgnoreCase(tport.getName())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.nameUsed", TPortEncapsulation.asTPort(nameDuplicationTPort));
                return;
            }
        }
        try {
            Long.parseLong(args[3]);
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.numberName", new Object[0]);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (Main.containsSpecialCharacter(args[3])) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.specialChars", "A-Z", "0-9", "-", "_");
                return;
            }
            if (tport.isPublicTPort()) {
                for (int publicSlot = 0; publicSlot < ListSize.getPublicTPortSize(); ++publicSlot) {
                    String tportID;
                    TPort publicTPort;
                    if (!Files.tportData.getConfig().contains("public.tports." + publicSlot) || (publicTPort = TPortManager.getTPort(UUID.fromString(tportID = Files.tportData.getConfig().getString("public.tports." + publicSlot, TPortManager.defUUID.toString())))) == null || !publicTPort.getName().equalsIgnoreCase(args[3])) continue;
                    ColorTheme.sendErrorTranslation(player, "tport.command.edit.name.nameUsedPublic", TPortEncapsulation.asTPort(publicTPort));
                    return;
                }
            }
            tport.setName(args[3]);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "Successfully set new name to %s", TPortEncapsulation.asTPort(tport));
            return;
        }
    }
}

