/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;

public class Move
extends SubCommand {
    private static final Move instance = new Move();
    public final EmptyCommand emptySlot = new EmptyCommand();

    public static Move getInstance() {
        return instance;
    }

    private Move() {
        this.emptySlot.setCommandName("slot", ArgumentType.REQUIRED);
        this.emptySlot.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.move.slot.commandDescription", "1", 24));
        this.emptySlot.setPermissions("TPort.edit.move", "TPort.basic");
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.move.tport.commandDescription", new Object[0]));
        emptyTPort.setPermissions(this.emptySlot.getPermissions());
        this.addAction(this.emptySlot);
        this.addAction(emptyTPort);
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptySlot.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        List<String> list = IntStream.rangeClosed(1, 24).mapToObj(String::valueOf).collect(Collectors.toList());
        list.addAll(TPortManager.getTPortList(player.getUniqueId()).stream().map(TPort::getName).toList());
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> move <slot|TPort name>");
            return;
        }
        if (!this.emptySlot.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        TPort secondTPort = TPortManager.getTPort(player.getUniqueId(), args[3]);
        if (secondTPort != null) {
            int tmpSlot = secondTPort.getSlot();
            secondTPort.setSlot(tport.getSlot());
            tport.setSlot(tmpSlot);
            tport.save();
            secondTPort.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.move.tport.succeeded", TPortEncapsulation.asTPort(tport), TPortEncapsulation.asTPort(secondTPort));
        } else {
            try {
                int newSlot = Integer.parseInt(args[3]) - 1;
                secondTPort = TPortManager.getTPort(player.getUniqueId(), newSlot);
                if (secondTPort != null) {
                    this.run(new String[]{"edit", tport.getName(), "move", secondTPort.getName()}, player);
                } else {
                    if (newSlot < 0 || newSlot >= 24) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.edit.move.slot.slotOutOfBounds", "1", 24);
                        return;
                    }
                    tport.setSlot(newSlot);
                    tport.save();
                    ColorTheme.sendSuccessTranslation(player, "tport.command.edit.move.slot.succeeded", TPortEncapsulation.asTPort(tport), String.valueOf(newSlot + 1));
                }
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.move.invalidArgument", args[3]);
            }
        }
    }
}

