/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import org.bukkit.entity.Player;

public class Location
extends SubCommand {
    public Location() {
        this.setPermissions("TPort.edit.location", "TPort.basic");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.location.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> name <new TPort name>");
            return;
        }
        if (!this.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.location.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        tport.setLocation(player.getLocation());
        tport.save();
        ColorTheme.sendSuccessTranslation(player, "tport.command.edit.location.succeeded", TPortEncapsulation.asTPort(tport));
    }
}

