/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Item
extends SubCommand {
    public Item() {
        this.setPermissions("TPort.edit.item", "TPort.basic");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.item.commandDescription", new Object[0]));
    }

    public static void setTPortDisplayItem(Player player, TPort tport) {
        Item.setTPortDisplayItem(player, tport, null, false);
    }

    public static void setTPortDisplayItem(Player player, TPort tport, @Nullable ItemStack item, boolean takeOne) {
        boolean takeFromMainHand;
        boolean bl = takeFromMainHand = item == null;
        if (takeFromMainHand && (item = player.getInventory().getItemInMainHand()).getType().equals((Object)Material.AIR)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.item.noItem", new Object[0]);
            return;
        }
        boolean returnItem = tport.shouldReturnItem();
        boolean takeItem = Features.Feature.TPortTakesItem.isEnabled();
        ItemStack oldItem = tport.getItem();
        if (returnItem && takeItem) {
            if (takeFromMainHand) {
                player.getInventory().setItemInMainHand(oldItem);
            } else {
                if (takeOne) {
                    for (ItemStack is : player.getInventory().getContents()) {
                        if (is == null || !is.equals((Object)item)) continue;
                        is.setAmount(is.getAmount() - 1);
                        item.setAmount(1);
                        break;
                    }
                } else {
                    player.getInventory().remove(item);
                }
                Main.giveItems(player, oldItem);
            }
        } else if (returnItem) {
            Main.giveItems(player, oldItem);
        } else if (takeItem) {
            if (takeFromMainHand) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            } else if (takeOne) {
                for (ItemStack is : player.getInventory().getContents()) {
                    if (is == null || !is.equals((Object)item)) continue;
                    is.setAmount(is.getAmount() - 1);
                    item.setAmount(1);
                    break;
                }
            } else {
                player.getInventory().remove(item);
            }
        }
        tport.setItem(item);
        tport.setShouldReturnItem(takeItem);
        tport.save();
        TPortAdvancement.Advancement_notMyStyle.grant(player);
        ColorTheme.sendSuccessTranslation(player, "tport.command.edit.item.succeeded", TPortEncapsulation.asTPort(tport), item);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> item");
            return;
        }
        if (!this.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.item.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        Item.setTPortDisplayItem(player, tport);
    }
}

