/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.delay;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Set
extends SubCommand {
    private final EmptyCommand emptyPlayerDelay = new EmptyCommand();

    public Set() {
        this.emptyPlayerDelay.setCommandName("delay", ArgumentType.REQUIRED);
        this.emptyPlayerDelay.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.delay.set.player.delay.commandDescription", "/tport delay permission command"));
        this.emptyPlayerDelay.setPermissions("TPort.delay.set", "TPort.admin.delay");
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.addAction(this.emptyPlayerDelay);
        this.addAction(emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (this.emptyPlayerDelay.hasPermissionToRun(player, false) && !Delay.isPermissionBased()) {
            return PlayerUUID.getPlayerNames();
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        int delay;
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay set <player> <delay>");
            return;
        }
        if (!this.emptyPlayerDelay.hasPermissionToRun(player, true)) {
            return;
        }
        if (Delay.isPermissionBased()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.delay.set.player.delay.managedByPermissions", ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.delay.type.permissions", new Object[0]), "/tport delay handler command");
            return;
        }
        UUID newUUID = PlayerUUID.getPlayerUUID(args[2], player);
        if (newUUID == null) {
            return;
        }
        try {
            delay = Integer.parseInt(args[3]);
            delay = Math.max(0, delay);
        }
        catch (NumberFormatException nfe) {
            ColorTheme.sendErrorTranslation(player, "tport.command.delay.set.player.delay.invalidTime", args[3]);
            return;
        }
        Files.tportConfig.getConfig().set("delay.time." + String.valueOf(newUUID), (Object)delay);
        Files.tportConfig.saveConfig();
        double seconds = (double)delay / 20.0;
        Message secondMessage = seconds == 1.0 ? ColorTheme.formatSuccessTranslation("tport.command.second", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.seconds", new Object[0]);
        Message tickMessage = delay == 1 ? ColorTheme.formatSuccessTranslation("tport.command.minecraftTick", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.minecraftTicks", new Object[0]);
        if (player.getUniqueId().equals(newUUID)) {
            ColorTheme.sendSuccessTranslation(player, "tport.command.delay.set.player.delay.succeededOwn", delay, tickMessage, seconds, secondMessage);
        } else {
            Player otherPlayer = Bukkit.getPlayer((UUID)newUUID);
            ColorTheme.sendSuccessTranslation(player, "tport.command.delay.set.player.delay.succeeded", PlayerEncapsulation.asPlayer(otherPlayer, newUUID), delay, tickMessage, seconds, secondMessage);
            ColorTheme.sendInfoTranslation(otherPlayer, "tport.command.delay.set.player.delay.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), delay, tickMessage, seconds, secondMessage);
        }
    }
}

