/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.blueMap;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.webMaps.BlueMapHandler;
import java.util.Collection;
import org.bukkit.entity.Player;

public class Colors
extends SubCommand {
    private final EmptyCommand colorTheme = new EmptyCommand();

    public Colors() {
        this.colorTheme.setCommandName("color theme", ArgumentType.OPTIONAL);
        this.colorTheme.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.colors.colorTheme.commandDescription", new Object[0]));
        this.colorTheme.setPermissions("TPort.blueMap.colors", "TPort.admin.blueMap");
        this.addAction(this.colorTheme);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.colors.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return ColorTheme.getDefaultThemes();
    }

    public static String getBlueMapThemeName() {
        return Files.tportConfig.getConfig().getString("blueMap.colors", "developerTheme");
    }

    public static ColorTheme getBlueMapTheme() {
        return ColorTheme.getDefaultTheme(Colors.getBlueMapThemeName());
    }

    public static void setBlueMapTheme(String theme) {
        if (ColorTheme.getDefaultThemes().contains(theme)) {
            Files.tportConfig.getConfig().set("blueMap.colors", (Object)theme);
            Files.tportConfig.saveConfig();
            try {
                BlueMapHandler.loadTPorts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            String blueMapThemeName = Colors.getBlueMapThemeName();
            ColorTheme.sendInfoTranslation(player, "tport.command.blueMapCommand.colors.succeeded", blueMapThemeName);
        } else if (args.length == 3) {
            if (!this.colorTheme.hasPermissionToRun(player, true)) {
                return;
            }
            if (ColorTheme.getDefaultThemesMap().containsKey(args[2])) {
                Colors.setBlueMapTheme(args[2]);
                ColorTheme.sendSuccessTranslation(player, "tport.command.blueMapCommand.colors.colorTheme.succeeded", args[2]);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.blueMapCommand.colors.colorTheme.themeNotFound", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport blueMap colors [colorTheme]");
        }
    }
}

