/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.biomeTP;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.inventories.TPortInventories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Preset
extends SubCommand {
    private static final Preset instance = new Preset();

    public static Preset getInstance() {
        return instance;
    }

    private Preset() {
        this.setPermissions("TPort.biomeTP.preset");
        EmptyCommand emptyPreset = new EmptyCommand();
        emptyPreset.setCommandName("preset", ArgumentType.OPTIONAL);
        emptyPreset.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.preset.preset.commandDescription", "/tport biomeTP whitelist/blacklist <biome...>"));
        emptyPreset.setPermissions(this.getPermissions());
        this.addAction(emptyPreset);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.preset.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return BiomePreset.getNames(player.getWorld());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (this.hasPermissionToRun(player, true)) {
                TPortInventories.openBiomeTPPreset(player, 0, null);
            }
        } else if (args.length == 3) {
            BiomePreset preset;
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            Object biomePreset = args[2];
            if (((String)biomePreset).startsWith("#minecraft:")) {
                biomePreset = "#" + ((String)biomePreset).substring(11);
            }
            if ((preset = BiomePreset.getPreset((String)biomePreset, player.getWorld())) == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.preset.presetNotExist", args[2]);
                return;
            }
            ArrayList<String> command = new ArrayList<String>(Arrays.asList("biomeTP", preset.whitelist() ? "whitelist" : "blacklist"));
            List<String> generatedBiomes = BiomeTP.availableBiomes(player.getWorld());
            for (String biome : preset.biomes()) {
                if (!generatedBiomes.contains(biome)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.preset.biome.worldNotGenerateBiome", biome);
                    continue;
                }
                command.add(biome);
            }
            if (command.size() == 2) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.preset.biome.noBiomesLeft", new Object[0]);
                return;
            }
            TPortCommand.executeTPortCommand((CommandSender)player, command.toArray(new String[0]));
            TPortAdvancement.Advancement_BiomeTP_OneIsNotEnough.grant(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP preset [preset]");
        }
    }
}

