/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.biomeTP;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.commands.tport.biomeTP.Mode;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class Blacklist
extends SubCommand {
    public Blacklist() {
        EmptyCommand emptyBlacklist = new EmptyCommand();
        emptyBlacklist.setCommandName("biome", ArgumentType.REQUIRED);
        emptyBlacklist.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.blacklist.biome.commandDescription", new Object[]{ColorTheme.ColorType.infoColor}));
        emptyBlacklist.setTabRunnable((args, player) -> {
            if (!PermissionHandler.hasPermission(player, false, true, "TPort.biomeTP.blacklist")) {
                return Collections.emptyList();
            }
            List<String> biomeList = Arrays.asList(args).subList(2, args.length).stream().map(String::toLowerCase).toList();
            return BiomeTP.availableBiomes(player.getWorld()).stream().filter(name -> biomeList.stream().noneMatch(name::equals)).toList();
        });
        emptyBlacklist.setLooped(true);
        emptyBlacklist.setPermissions("TPort.biomeTP.blacklist", "TPort.biomeTP.biome.<biome...>");
        emptyBlacklist.permissionsOR(false);
        this.addAction(emptyBlacklist);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!PermissionHandler.hasPermission(player, false, true, "TPort.biomeTP.blacklist")) {
            return Collections.emptyList();
        }
        List<String> biomeList = Arrays.asList(args).subList(2, args.length).stream().map(String::toLowerCase).toList();
        return BiomeTP.availableBiomes(player.getWorld()).stream().filter(name -> biomeList.stream().noneMatch(name::equals)).toList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP blacklist <biome...>");
        } else {
            if (!PermissionHandler.hasPermission(player, true, true, "TPort.biomeTP.blacklist")) {
                return;
            }
            if (!CooldownManager.BiomeTP.hasCooled(player)) {
                return;
            }
            List<String> possibleBiomes = BiomeTP.availableBiomes(player.getWorld());
            ArrayList<String> blacklist = new ArrayList<String>();
            for (int i = 2; i < args.length; ++i) {
                String biomeName = args[i].toLowerCase();
                if (!possibleBiomes.contains(biomeName)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.blacklist.biome.worldNotGenerateBiome", biomeName);
                    continue;
                }
                if (blacklist.contains(biomeName)) {
                    Message biomeMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(biomeName));
                    ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.blacklist.biome.biomeAlreadyInList", biomeMessage);
                    continue;
                }
                blacklist.add(biomeName);
            }
            ArrayList<String> whitelist = new ArrayList<String>();
            for (String biome : possibleBiomes) {
                if (blacklist.contains(biome) || !PermissionHandler.hasPermission(player, true, true, "TPort.biomeTP.biome." + biome)) continue;
                whitelist.add(biome);
            }
            if (whitelist.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.blacklist.biome.noBiomesLeft", new Object[0]);
                return;
            }
            BiomeTP.biomeTP(player, Mode.getDefMode(player.getUniqueId()), whitelist);
        }
    }
}

