/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.biomeTP;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class Accuracy
extends SubCommand {
    private final EmptyCommand emptySize = new EmptyCommand();
    public static HashMap<String, AccuracySettings> accuracies = new HashMap();

    public Accuracy() {
        this.emptySize.setCommandName("size", ArgumentType.OPTIONAL);
        this.emptySize.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.accuracy.accuracy.commandDescription", new Object[0]));
        this.emptySize.setPermissions("TPort.biomeTP.accuracy", "TPort.admin.biomeTP");
        this.addAction(this.emptySize);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.accuracy.commandDescription", new Object[0]));
        this.registerBiomeTPAccuracies();
    }

    private void registerBiomeTPAccuracies() {
        Accuracy.createAccuracy("default", 6400, 8, Arrays.asList(200, 0));
        Accuracy.createAccuracy("fine", 4800, 6, Arrays.asList(200, 100, 0, -30));
        Accuracy.createAccuracy("fast", 6400, 8, List.of(Integer.valueOf(100)));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptySize.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return accuracies.keySet();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            AccuracySettings accuracy = Accuracy.getDefaultAccuracySettings();
            ColorTheme.sendInfoTranslation(player, "tport.command.biomeTP.accuracy.succeeded", accuracy);
        } else if (args.length == 3) {
            if (!this.emptySize.hasPermissionToRun(player, true)) {
                return;
            }
            if (Accuracy.setBiomeTPAccuracy(args[2])) {
                AccuracySettings accuracy = Accuracy.getDefaultAccuracySettings();
                ColorTheme.sendSuccessTranslation(player, "tport.command.biomeTP.accuracy.accuracy.succeeded", accuracy);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.accuracy.accuracy.notAnAccuracy", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP accuracy [accuracy]");
        }
    }

    public static boolean createAccuracy(String name, int range, int increment, List<Integer> yLevels) {
        if (!accuracies.containsKey(name)) {
            accuracies.put(name, new AccuracySettings(name, range, increment, yLevels));
            return true;
        }
        return false;
    }

    public static String getDefaultAccuracy() {
        return Files.tportConfig.getConfig().getString("biomeTP.accuracy", "default");
    }

    public static AccuracySettings getDefaultAccuracySettings() {
        String accuracy = Accuracy.getDefaultAccuracy();
        return Accuracy.getAccuracySettings(accuracy);
    }

    public static AccuracySettings getAccuracySettings(String accuracy) {
        AccuracySettings accuracySettings = accuracies.getOrDefault(accuracy, null);
        if (accuracySettings == null) {
            accuracySettings = new AccuracySettings("default", 6400, 8, Arrays.asList(0, 200));
        } else {
            accuracySettings.name = accuracy;
        }
        return accuracySettings;
    }

    public static boolean setBiomeTPAccuracy(String accuracy) {
        if (accuracies.containsKey(accuracy)) {
            Files.tportConfig.getConfig().set("biomeTP.accuracy", (Object)accuracy);
            Files.tportConfig.saveConfig();
            return true;
        }
        return false;
    }

    public static class AccuracySettings
    implements MessageUtils.MessageDescription {
        String name;
        int range;
        int increment;
        List<Integer> yLevels;

        public AccuracySettings(String name, int range, int increment, List<Integer> yLevels) {
            this.name = name;
            this.range = range;
            this.increment = increment;
            this.yLevels = yLevels;
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name, varColor));
        }

        @Override
        public String getInsertion() {
            return this.name;
        }

        public int getRange() {
            return this.range;
        }

        public int getIncrement() {
            return this.increment;
        }

        public List<Integer> getYLevels() {
            return this.yLevels;
        }

        @Override
        public Message getDescription() {
            Message message = new Message();
            message.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.accuracy.accuracySettings.hoverData.range", this.getRange()));
            message.addNewLine();
            message.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.accuracy.accuracySettings.hoverData.increment", this.getIncrement()));
            message.addNewLine();
            message.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.accuracy.accuracySettings.hoverData.yLevels", StringUtils.join(this.yLevels, (char)' ')));
            return message;
        }
    }
}

