/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.backup;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Reload;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.entity.Player;

public class Load
extends SubCommand {
    private final EmptyCommand emptyName = new EmptyCommand();

    public Load() {
        this.emptyName.setCommandName("name", ArgumentType.REQUIRED);
        this.emptyName.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.backup.load.commandDescription", new Object[0]));
        this.emptyName.setPermissions("TPort.admin.backup.load");
        this.addAction(this.emptyName);
    }

    public static List<String> getBackups(boolean sortByModify) {
        Stream<File> s = Arrays.stream(Objects.requireNonNull(new File(Main.getInstance().getDataFolder(), "backup").listFiles())).filter(f -> f.getName().endsWith(".yml") && !f.getName().contains(" "));
        if (sortByModify) {
            s = s.sorted((file1, file2) -> Long.compare(file2.lastModified(), file1.lastModified()));
        }
        return s.map(f -> f.getName().split("\\.")[0]).collect(Collectors.toList());
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyName.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Load.getBackups(false);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport backup load <name>");
            return;
        }
        if (!this.emptyName.hasPermissionToRun(player, true)) {
            return;
        }
        String fileName = args[2].split("\\.")[0];
        File file = new File(new File(Main.getInstance().getDataFolder(), "backup"), fileName + ".yml");
        if (!file.exists()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.backup.load.fileNotFound", fileName + ".yml");
            return;
        }
        Files configFile = new Files(Main.getInstance(), "backup", fileName);
        if (!configFile.getConfig().contains("tport")) {
            ColorTheme.sendErrorTranslation(player, "tport.command.backup.load.error", file.getName());
            return;
        }
        Files.tportData.getConfig().set("tport", (Object)configFile.getConfig().getConfigurationSection("tport"));
        Files.tportData.getConfig().set("public", (Object)configFile.getConfig().getConfigurationSection("public"));
        Files.tportData.saveConfig();
        ColorTheme.sendInfoTranslation(player, "tport.command.backup.load.reloading", new Object[0]);
        Reload.reloadTPort();
        ColorTheme.sendSuccessTranslation(player, "tport.command.backup.load.succeeded", fileName);
    }
}

