/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.waypoint.WaypointManager;
import com.spaceman.tport.waypoint.WaypointShowType;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Waypoints
extends SubCommand {
    private final EmptyCommand emptyTypeType = new EmptyCommand();

    public Waypoints() {
        this.emptyTypeType.setCommandName("type", ArgumentType.OPTIONAL);
        this.emptyTypeType.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.waypoints.type.type.commandDescription", new Object[0]));
        this.emptyTypeType.setPermissions("tport.waypoints.<type>");
        EmptyCommand emptyType = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyType.setCommandName("type", ArgumentType.FIXED);
        emptyType.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.waypoints.type.commandDescription", new Object[0]));
        emptyType.setTabRunnable((args, player) -> {
            if (!this.emptyTypeType.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            return Arrays.stream(WaypointShowType.values()).map(Enum::name).toList();
        });
        emptyType.addAction(this.emptyTypeType);
        this.addAction(emptyType);
    }

    public static WaypointShowType getWaypointShowType(UUID uuid) {
        WaypointShowType def = WaypointShowType.Own;
        return WaypointShowType.get(Files.tportData.getConfig().getString("tport." + String.valueOf(uuid) + ".waypoint.showType", def.name()), def);
    }

    public static void setWaypointShowType(UUID uuid, WaypointShowType waypointShowType) {
        Files.tportData.getConfig().set("tport." + String.valueOf(uuid) + ".waypoint.showType", (Object)waypointShowType.name());
        Files.tportData.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.waypoints.type.succeeded", Waypoints.getWaypointShowType(player.getUniqueId()));
        } else if (args.length == 3) {
            WaypointShowType showType = WaypointShowType.get(args[2], null);
            if (showType == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.waypoints.type.type.showTypeNotExist", args[2]);
                return;
            }
            Waypoints.setWaypointShowType(player.getUniqueId(), showType);
            ColorTheme.sendSuccessTranslation(player, "tport.command.waypoints.type.type.succeeded", showType);
            WaypointManager.removeFromWorld(player, player.getWorld().getName(), player.getWorld().getName());
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport waypoints type [type]");
        }
    }
}

