/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Adapter;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Version
extends SubCommand {
    public static String latestVersionName = "";
    public static String latestVersionJAR = "";

    public static String getLatestVersionName() {
        try {
            String urlAsString = "https://api.github.com/repos/JasperBouwman/TPort/releases/latest";
            URL url = new URL(urlAsString);
            URLConnection connection = url.openConnection();
            connection.connect();
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)connection.getContent()));
            JsonObject object = element.getAsJsonObject();
            for (JsonElement assetElement : object.getAsJsonArray("assets")) {
                JsonObject asset = assetElement.getAsJsonObject();
                String assetName = asset.get("name").toString();
                if (!assetName.endsWith(".jar")) continue;
                latestVersionJAR = asset.get("browser_download_url").toString();
            }
            String versionName = object.get("tag_name").toString();
            latestVersionName = versionName = versionName.substring(1, versionName.length() - 1);
            return versionName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isLatest(String[] latestVersion, String[] currentVersion, int index) {
        int current;
        if (latestVersion.length == index && currentVersion.length == index) {
            return true;
        }
        int latest = latestVersion.length == index ? 0 : Integer.parseInt(latestVersion[index]);
        int n = current = currentVersion.length == index ? 0 : Integer.parseInt(currentVersion[index]);
        if (current > latest) {
            return true;
        }
        if (current == latest) {
            return Version.isLatest(latestVersion, currentVersion, index + 1);
        }
        return false;
    }

    public static Boolean isLatestVersion() {
        String latestVersionName = Version.getLatestVersionName();
        if (latestVersionName == null) {
            return null;
        }
        String[] latestVersion = latestVersionName.substring(6).split("\\.");
        String[] currentVersion = Version.getCurrentVersion().split("\\.");
        return Version.isLatest(latestVersion, currentVersion, 0);
    }

    public static void checkForLatestVersion() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
            Boolean isLatest = Version.isLatestVersion();
            if (isLatest == null) {
                Main.getInstance().getLogger().log(Level.INFO, "Could not check for the latest version");
                return;
            }
            if (isLatest.booleanValue()) {
                Main.getInstance().getLogger().log(Level.INFO, "You are running the latest version of TPort");
                return;
            }
            String githubLink = "https://github.com/JasperBouwman/TPort/releases/tag/" + latestVersionName;
            String bukkitLink = "https://dev.bukkit.org/projects/tport/files";
            Main.getInstance().getLogger().log(Level.INFO, "There is a new version of TPort available. Download TPort here:");
            Main.getInstance().getLogger().log(Level.INFO, githubLink);
            Main.getInstance().getLogger().log(Level.INFO, "  or here:");
            Main.getInstance().getLogger().log(Level.INFO, bukkitLink);
            Main.getInstance().getLogger().log(Level.INFO, "Before downloading please check first for compatibility with your Minecraft/Bukkit version");
        });
    }

    public static String getCurrentVersion() {
        return Main.getInstance().getDescription().getVersion();
    }

    public Version() {
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.version.commandDescription", Version.getCurrentVersion()));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            int versions = Main.supportedVersions.length;
            String translationID = versions > 1 ? "tport.command.version.succeeded.multiple" : "tport.command.version.succeeded.singular";
            Message versionsMessage = new Message();
            if (versions != 0) {
                for (String version : Main.supportedVersions) {
                    versionsMessage.addText(TextComponent.textComponent(version, ColorTheme.ColorType.varInfoColor));
                    versionsMessage.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.infoColor));
                }
                versionsMessage.removeLast();
            } else {
                versionsMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.command.version.succeeded.unknown", new Object[0]);
            }
            JsonObject playerLang = Language.getPlayerLang(player);
            Message changelogMessage = ColorTheme.formatInfoTranslation("tport.command.version.succeeded.changelog", new Object[0]).translateMessage(playerLang);
            ColorTheme.sendInfoTranslation(player, translationID, TextComponent.textComponent(Version.getCurrentVersion(), ColorTheme.ColorType.varInfoColor, new HoverEvent(changelogMessage), ClickEvent.openUrl("https://github.com/JasperBouwman/TPort/blob/master/changelog.md#version-" + Version.getCurrentVersion().replace(".", ""))), versionsMessage, TextComponent.textComponent("https://github.com/JasperBouwman/TPort", ColorTheme.ColorType.varInfoColor, HoverEvent.hoverEvent(TextComponent.textComponent("https://github.com/JasperBouwman/TPort", ColorTheme.ColorType.varInfoColor)), ClickEvent.openUrl("https://github.com/JasperBouwman/TPort")), TextComponent.textComponent(Main.getInstance().getDescription().getWebsite(), ColorTheme.ColorType.varInfoColor, HoverEvent.hoverEvent(TextComponent.textComponent(Main.getInstance().getDescription().getWebsite(), ColorTheme.ColorType.varInfoColor)), ClickEvent.openUrl(Main.getInstance().getDescription().getWebsite())), TextComponent.textComponent("https://discord.gg/tq5RTmSbHU", ColorTheme.ColorType.varInfoColor, HoverEvent.hoverEvent(TextComponent.textComponent("https://discord.gg/tq5RTmSbHU", ColorTheme.ColorType.varInfoColor)), ClickEvent.openUrl("https://discord.gg/tq5RTmSbHU")), Bukkit.getVersion(), Bukkit.getBukkitVersion(), Adapter.getLoadedAdapter(), Adapter.getSelectedAdapter());
            Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                Boolean isLatest = Version.isLatestVersion();
                if (isLatest == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.version.couldNotCheck", new Object[0]);
                } else if (isLatest.booleanValue()) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.version.isLatest", new Object[0]);
                } else {
                    ColorTheme.sendInfoTranslation(player, "tport.command.version.isNotLatest", latestVersionName);
                }
            });
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport version");
        }
    }
}

