/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.ItemFactory;
import com.spaceman.tport.inventories.SettingsInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.search.SearchType;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.OldEnum;

public class Search
extends SubCommand {
    private static final Search instance = new Search();
    private boolean alreadyRegistered = false;

    private Search() {
    }

    public static Search getInstance() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.search.commandDescription", new Object[0]));
        instance.addAction(empty);
        instance.registerSearchers();
        return instance;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            SettingsInventories.openMainSearchGUI(player, 0);
            return;
        }
        if (args.length > 1) {
            for (SubCommand action : this.getActions()) {
                if (!action.getName(args[1]).equalsIgnoreCase(args[1]) && !action.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(args[1]))) continue;
                if (!CooldownManager.Search.hasCooled(player, true)) {
                    return;
                }
                action.run(args, player);
                return;
            }
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport search <type> [mode] <searched...>");
    }

    private void registerSearchers() {
        if (this.alreadyRegistered) {
            return;
        }
        this.alreadyRegistered = true;
        SearchType searchType = new SearchType("TPort");
        searchType.setInventoryModel(SettingsInventories.settings_search_tport_model);
        searchType.setQuery("TPort name", false, false, null, null);
        searchType.hasSearchMode(true);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!searchMode.fits(tport.getName(), query)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("description");
        searchType.setInventoryModel(SettingsInventories.settings_search_description_model);
        searchType.setQuery("description", true, false, null, null);
        searchType.hasSearchMode(true);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!searchMode.fits(tport.getTextDescription().replace("\n", ""), query)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("player");
        searchType.setInventoryModel(SettingsInventories.settings_search_player_model);
        searchType.setQuery("player", false, false, (args, player) -> PlayerUUID.getPlayerNames(), null);
        searchType.hasSearchMode(true);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                if (!searchMode.fits(PlayerUUID.getPlayerName(uuid), query)) continue;
                list.add(Main.getOrDefault(ItemFactory.getHead(UUID.fromString(uuid), player, List.of(ItemFactory.HeadAttributes.TPORT_AMOUNT, ItemFactory.HeadAttributes.CLICK_EVENTS), null), new ItemStack(Material.AIR)));
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("ownedTPorts");
        searchType.setInventoryModel(SettingsInventories.settings_search_owned_tports_model);
        searchType.setQuery("amount", false, true, (args, player) -> IntStream.range(0, 24).mapToObj(String::valueOf).toList(), null);
        searchType.hasSearchMode(true);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int i = Integer.parseInt(query);
            for (String uuidString : Files.tportData.getKeys("tport")) {
                UUID uuid = UUID.fromString(uuidString);
                if (!searchMode.fits(TPortManager.getTPortList(uuid).size(), i)) continue;
                list.add(Main.getOrDefault(ItemFactory.getHead(uuid, player, List.of(ItemFactory.HeadAttributes.TPORT_AMOUNT, ItemFactory.HeadAttributes.CLICK_EVENTS), null), new ItemStack(Material.AIR)));
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("canTP");
        searchType.setInventoryModel(SettingsInventories.settings_search_can_tp_model);
        searchType.removeQuery();
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!tport.canTeleport(player, false, false, false)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("biome");
        searchType.setInventoryModel(SettingsInventories.settings_search_biome_model);
        searchType.setQuery("biome", true, false, (args, player) -> {
            List<String> biomeList = Arrays.asList(args).subList(2, args.length).stream().map(String::toUpperCase).toList();
            return Arrays.stream(Biome.values()).map(OldEnum::name).filter(name -> !biomeList.contains(name)).collect(Collectors.toList());
        }, player -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ColorTheme colorTheme = ColorTheme.getTheme(player);
            JsonObject playerLang = Language.getPlayerLang(player);
            for (String biome : BiomeTP.availableBiomes()) {
                ItemStack is = new ItemStack(BiomeTP.getMaterial(biome));
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "query"), biome);
                Message biomeTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(biome)).translateMessage(playerLang);
                MessageUtils.setCustomItemData(is, colorTheme, biomeTitle, null);
                items.add(is);
            }
            return items;
        });
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            String[] split = query.split(" ");
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!Arrays.stream(split).anyMatch(s -> s.equalsIgnoreCase(tport.getBiome().name()))) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("biomePreset");
        searchType.setInventoryModel(SettingsInventories.settings_search_biome_preset_model);
        searchType.setQuery("preset", false, false, (args, player) -> BiomePreset.getNames(player.getWorld()), player -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (BiomePreset preset : Iterables.concat(BiomePreset.getBiomePresets(), BiomePreset.getTagPresets(player.getWorld()))) {
                ItemStack is = new ItemStack(preset.material());
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "query"), preset.name());
                items.add(is);
            }
            return items;
        });
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            BiomePreset preset = BiomePreset.getPreset(query, player.getLocation().getWorld());
            List<String> biomes = preset.biomes();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (preset.whitelist()) {
                        if (!biomes.stream().anyMatch(b -> b.equalsIgnoreCase(tport.getBiome().name()))) continue;
                        list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                        continue;
                    }
                    if (!biomes.stream().noneMatch(b -> b.equalsIgnoreCase(tport.getBiome().name()))) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("dimension");
        searchType.setInventoryModel(SettingsInventories.settings_search_dimension_model);
        searchType.setQuery("dimension", false, false, (args, player) -> Arrays.stream(World.Environment.values()).map(Enum::name).collect(Collectors.toList()), player -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (World.Environment environment : World.Environment.values()) {
                ItemStack is = (switch (environment) {
                    case World.Environment.NORMAL -> SettingsInventories.settings_search_dimension_overworld_model;
                    case World.Environment.NETHER -> SettingsInventories.settings_search_dimension_nether_model;
                    case World.Environment.THE_END -> SettingsInventories.settings_search_dimension_the_end_model;
                    default -> SettingsInventories.settings_search_dimension_other_environments_model;
                }).getItem(player);
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "query"), environment.name());
                items.add(is);
            }
            return items;
        });
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!tport.getDimension().name().equalsIgnoreCase(query)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("world");
        searchType.setInventoryModel(SettingsInventories.settings_search_world_model);
        searchType.setQuery("world", false, false, (args, player) -> Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList()), player -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (World world : Bukkit.getWorlds()) {
                ItemStack is = (switch (world.getEnvironment()) {
                    case World.Environment.NORMAL -> SettingsInventories.settings_search_world_overworld_model;
                    case World.Environment.NETHER -> SettingsInventories.settings_search_world_nether_model;
                    case World.Environment.THE_END -> SettingsInventories.settings_search_world_the_end_model;
                    default -> SettingsInventories.settings_search_world_other_worlds_model;
                }).getItem(player);
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "query"), world.getName());
                items.add(is);
            }
            return items;
        });
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!tport.getWorld().getName().equalsIgnoreCase(query)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
        searchType = new SearchType("tag");
        searchType.setInventoryModel(SettingsInventories.settings_search_tag_model);
        searchType.setQuery("tag", false, false, (args, player) -> Tag.getTags(), player -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (String tag : Tag.getTags()) {
                ItemStack is = SettingsInventories.settings_search_tag_tags_model.getItem(player);
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "query"), tag);
                items.add(is);
            }
            return items;
        });
        searchType.hasSearchMode(false);
        searchType.setSearcher((searchMode, query, player) -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!tport.getTags().contains(query)) continue;
                    list.add(ItemFactory.toTPortItem(tport, player, List.of(ItemFactory.TPortItemAttributes.ADD_OWNER, ItemFactory.TPortItemAttributes.CLICK_TO_OPEN)));
                }
            }
            return list;
        });
        Searchers.addSearcher(searchType);
    }

    public static class Searchers {
        private static final HashMap<String, SearchType> searchers = new HashMap();

        public static boolean addSearcher(SearchType searchType) {
            if (searchType.hasSearcher() && !searchers.containsKey(searchType.getSearchTypeName())) {
                searchers.put(searchType.getSearchTypeName(), searchType);
                instance.addAction(searchType.buildCommand());
                return true;
            }
            return false;
        }

        public static Collection<SearchType> getSearchers() {
            return searchers.values();
        }

        public static SearchType getSearcher(String name) {
            return searchers.getOrDefault(name, null);
        }
    }
}

