/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.SettingsInventories;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SafetyCheck
extends SubCommand {
    private final EmptyCommand emptyCheck;
    private static SafetyChecker safetyChecker = (l, clearFeet) -> true;

    public SafetyCheck() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        this.emptyCheck = new EmptyCommand();
        this.emptyCheck.setCommandName("check", ArgumentType.FIXED);
        this.emptyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.safetyCheck.check.commandDescription", new Object[0]));
        this.emptyCheck.setPermissions("TPort.safetyCheck.check", "TPort.basic");
        EmptyCommand emptySourceState = new EmptyCommand();
        emptySourceState.setCommandName("state", ArgumentType.OPTIONAL);
        emptySourceState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.safetyCheck.source.state.commandDescription", new Object[0]));
        emptySourceState.setPermissions("TPort.safetyCheck.<source>", "TPort.basic");
        EmptyCommand emptySource = new EmptyCommand();
        emptySource.setCommandName("source", ArgumentType.OPTIONAL);
        emptySource.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.safetyCheck.source.commandDescription", new Object[0]));
        emptySource.setTabRunnable((args, player) -> SafetyCheckSource.get(args[1]) != null ? List.of("true", "false") : List.of());
        emptySource.addAction(emptySourceState);
        this.addAction(empty);
        this.addAction(this.emptyCheck);
        this.addAction(emptySource);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.safetyCheck.commandDescription", new Object[0]));
    }

    public static void setSafetyCheck(SafetyChecker safetyChecker) {
        SafetyCheck.safetyChecker = safetyChecker;
    }

    public static boolean isSafe(Location feet) {
        return safetyChecker.isSafe(feet, false);
    }

    public static boolean isSafe(Location feet, boolean clearFeet) {
        return safetyChecker.isSafe(feet, clearFeet);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        List<String> list = Arrays.stream(SafetyCheckSource.values()).map(Enum::name).collect(Collectors.toList());
        list.add("check");
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.SafetyCheck.isDisabled()) {
            Features.Feature.SafetyCheck.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            Message list = new Message();
            Message delimiter = ColorTheme.formatInfoTranslation("tport.command.safetyCheck.delimiter", new Object[0]);
            SafetyCheckSource[] values = SafetyCheckSource.values();
            boolean color = true;
            for (int i = 0; i < values.length; ++i) {
                SafetyCheckSource source = values[i];
                TextComponent stateMessage = source.getState(player) ? TextComponent.textComponent("true", ColorTheme.ColorType.goodColor).addTextEvent(HoverEvent.hoverEvent("/tport safetyCheck " + source.name() + " false", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport safetyCheck " + source.name() + " false")).setInsertion("/tport safetyCheck " + source.name() + " false") : TextComponent.textComponent("false", ColorTheme.ColorType.badColor).addTextEvent(HoverEvent.hoverEvent("/tport safetyCheck " + source.name() + " true", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport safetyCheck " + source.name() + " true")).setInsertion("/tport safetyCheck " + source.name() + " true");
                if (color) {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.safetyCheck.listElement", source, stateMessage));
                } else {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.safetyCheck.listElement", source, stateMessage));
                }
                boolean bl = color = !color;
                if (i + 2 == values.length) {
                    list.addMessage(ColorTheme.formatInfoTranslation("tport.command.safetyCheck.lastDelimiter", new Object[0]));
                    continue;
                }
                list.addMessage(delimiter);
            }
            ColorTheme.sendInfoTranslation(player, "tport.command.safetyCheck.succeeded", list);
            return;
        }
        if (args.length == 2 && args[1].equalsIgnoreCase("check")) {
            if (!this.emptyCheck.hasPermissionToRun(player, true)) {
                return;
            }
            Message state = safetyChecker.isSafe(player.getLocation(), false) ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.goodColor, "tport.command.safetyCheck.check.safe", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.badColor, "tport.command.safetyCheck.check.unsafe", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.safetyCheck.check.succeeded", state);
            return;
        }
        if (args.length == 2 || args.length == 3) {
            SafetyCheckSource source = SafetyCheckSource.get(args[1]);
            if (source == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.safetyCheck.source.sourceNotFound", new Object[0]);
                return;
            }
            if (args.length == 2) {
                ColorTheme.sendInfoTranslation(player, "tport.command.safetyCheck.source.succeeded", source, source.getState(player));
            } else {
                Boolean newState = Main.toBoolean(args[2]);
                if (newState == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport safetyCheck <source> <true|false>");
                    return;
                }
                if (source.setState(player, newState)) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.safetyCheck.source.state.succeeded", source, source.getState(player));
                }
            }
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport safetyCheck [source|state]");
    }

    @FunctionalInterface
    public static interface SafetyChecker {
        public boolean isSafe(Location var1, boolean var2);
    }

    public static enum SafetyCheckSource implements MessageUtils.MessageDescription
    {
        TPORT_OPEN(SettingsInventories.settings_safety_check_tport_open_model, SettingsInventories.settings_safety_check_tport_open_grayed_model),
        TPORT_OWN(SettingsInventories.settings_safety_check_tport_own_model, SettingsInventories.settings_safety_check_tport_own_grayed_model),
        TPORT_HOME(SettingsInventories.settings_safety_check_tport_home_model, SettingsInventories.settings_safety_check_tport_home_grayed_model),
        TPORT_BACK(SettingsInventories.settings_safety_check_tport_back_model, SettingsInventories.settings_safety_check_tport_back_grayed_model),
        PLTP(SettingsInventories.settings_safety_check_pltp_model, SettingsInventories.settings_safety_check_pltp_grayed_model),
        TPORT_PUBLIC(SettingsInventories.settings_safety_check_tport_public_model, SettingsInventories.settings_safety_check_tport_public_grayed_model);

        private final InventoryModel enabledModel;
        private final InventoryModel disabledModel;

        private SafetyCheckSource(InventoryModel enabledModel, InventoryModel disabledModel) {
            this.enabledModel = enabledModel;
            this.disabledModel = disabledModel;
        }

        public InventoryModel getModel(Player player) {
            return this.getState(player) ? this.enabledModel : this.disabledModel;
        }

        public String getPermission() {
            return "TPort.safetyCheck." + this.name();
        }

        public boolean hasPermission(Player player, boolean sendMessage) {
            if (Features.Feature.SafetyCheck.isDisabled()) {
                if (sendMessage) {
                    Features.Feature.SafetyCheck.sendDisabledMessage(player);
                }
                return false;
            }
            return PermissionHandler.hasPermission(player, sendMessage, true, this.getPermission(), "TPort.basic");
        }

        public boolean getState(Player player) {
            if (this.hasPermission(player, false)) {
                return Files.tportData.getConfig().getBoolean("tport." + String.valueOf(player.getUniqueId()) + ".safetyCheck." + this.name() + ".state", true);
            }
            return false;
        }

        public boolean setState(Player player, boolean state) {
            if (this.hasPermission(player, true)) {
                Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".safetyCheck." + this.name() + ".state", (Object)state);
                Files.tportData.saveConfig();
                return true;
            }
            return false;
        }

        public static SafetyCheckSource get(String name) {
            for (SafetyCheckSource source : SafetyCheckSource.values()) {
                if (!source.name().equalsIgnoreCase(name)) continue;
                return source;
            }
            return null;
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.command.safetyCheck.safetyCheckSource." + this.name() + ".description", new Object[0]);
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name(), varColor));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }
    }
}

