/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.requests.Accept;
import com.spaceman.tport.commands.tport.requests.Reject;
import com.spaceman.tport.commands.tport.requests.Revoke;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tpEvents.TPRequest;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Requests
extends SubCommand {
    public Requests() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.requests.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(new Accept());
        this.addAction(new Reject());
        this.addAction(new Revoke());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run(String[] args, Player player) {
        if (args.length != 1) {
            if (CommandTemplate.runCommands(this.getActions(), args[1], args, player)) return;
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport requests " + CommandTemplate.convertToArgs(this.getActions(), true));
            return;
        }
        TPRequest sendRequest = TPRequest.getRequest(player.getUniqueId());
        ArrayList<TPRequest> requests = TPRequest.getRequestsToYou(player.getUniqueId());
        if (sendRequest == null && requests.isEmpty()) {
            ColorTheme.sendInfoTranslation(player, "tport.command.requests.noRequests", new Object[0]);
            return;
        }
        if (sendRequest != null) {
            Player p;
            TPort tport;
            ColorTheme.sendInfoTranslation(player, "tport.command.requests.sendRequest", sendRequest.toInfo());
            if (sendRequest.isTPortRequest() ? (tport = TPortManager.getTPort(sendRequest.getRequestToUUID(), sendRequest.getTPortUUID())) == null : (p = Bukkit.getPlayer((UUID)sendRequest.getRequestToUUID())) != null) {
                // empty if block
            }
        }
        if (requests.isEmpty()) return;
        Message list = new Message();
        int size = requests.size();
        boolean color = true;
        int i = 0;
        while (true) {
            if (i >= size) {
                list.removeLast();
                ColorTheme.sendInfoTranslation(player, "tport.command.requests.receiveRequests", list);
                return;
            }
            TPRequest request = requests.get(i);
            Player requester = Bukkit.getPlayer((UUID)request.getRequesterUUID());
            assert (requester != null);
            if (color) {
                accept = TextComponent.textComponent("tport.command.requests.accept", ColorTheme.ColorType.varInfoColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport requests accept " + requester.getName(), ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport requests accept " + requester.getName())).setInsertion("/tport requests accept " + requester.getName());
                reject = TextComponent.textComponent("tport.command.requests.reject", ColorTheme.ColorType.varInfoColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport requests reject " + requester.getName(), ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport requests reject " + requester.getName())).setInsertion("/tport requests reject " + requester.getName());
                list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.requests.listElement", PlayerEncapsulation.asPlayer(requester), request.toInfo(), accept, reject));
            } else {
                accept = TextComponent.textComponent("tport.command.requests.accept", ColorTheme.ColorType.varInfo2Color).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport requests accept " + requester.getName(), ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport requests accept " + requester.getName())).setInsertion("/tport requests accept " + requester.getName());
                reject = TextComponent.textComponent("tport.command.requests.reject", ColorTheme.ColorType.varInfo2Color).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport requests reject " + requester.getName(), ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport requests reject " + requester.getName())).setInsertion("/tport requests reject " + requester.getName());
                list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.listElement", PlayerEncapsulation.asPlayer(requester), request.toInfo2(), accept, reject));
            }
            if (i + 2 == size) {
                list.addMessage(ColorTheme.formatInfoTranslation("tport.command.requests.lastDelimiter", new Object[0]));
            } else {
                list.addMessage(ColorTheme.formatInfoTranslation("tport.command.requests.delimiter", new Object[0]));
            }
            color = !color;
            ++i;
        }
    }
}

