/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.SettingsInventories;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Redirect
extends SubCommand {
    private final EmptyCommand emptyRedirectState;

    public Redirect() {
        Redirects.loadRedirects();
        this.emptyRedirectState = new EmptyCommand();
        this.emptyRedirectState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyRedirectState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.state.commandDescription", new Object[0]));
        this.emptyRedirectState.setPermissions("TPort.redirect.set", "TPort.admin.redirect");
        EmptyCommand emptyRedirect = new EmptyCommand();
        emptyRedirect.setCommandName("redirect", ArgumentType.OPTIONAL);
        emptyRedirect.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.commandDescription", "/tport help redirects"));
        emptyRedirect.setTabRunnable((args, player) -> Arrays.asList("true", "false"));
        emptyRedirect.addAction(this.emptyRedirectState);
        this.addAction(emptyRedirect);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.redirect.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Arrays.stream(Redirects.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.Redirects.isDisabled()) {
            Features.Feature.Redirects.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            Message list = new Message();
            Message delimiter = ColorTheme.formatInfoTranslation("tport.command.redirect.delimiter", new Object[0]);
            Redirects[] redirects = Redirects.values();
            boolean color = true;
            for (int i = 0; i < redirects.length; ++i) {
                Redirects redirect = redirects[i];
                TextComponent stateMessage = redirect.isEnabled() ? TextComponent.textComponent("tport.command.redirect.redirect.enabled", ColorTheme.ColorType.goodColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport redirect " + redirect.name() + " false", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport redirect " + redirect.name() + " false")).setInsertion("/tport redirect " + redirect.name() + " false") : TextComponent.textComponent("tport.command.redirect.redirect.disabled", ColorTheme.ColorType.badColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport redirect " + redirect.name() + " true", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport redirect " + redirect.name() + " true")).setInsertion("/tport redirect " + redirect.name() + " true");
                if (color) {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.redirect.listElement", redirect, stateMessage));
                } else {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.redirect.listElement", redirect, stateMessage));
                }
                boolean bl = color = !color;
                if (i + 2 == redirects.length) {
                    list.addMessage(ColorTheme.formatInfoTranslation("tport.command.redirect.lastDelimiter", new Object[0]));
                    continue;
                }
                list.addMessage(delimiter);
            }
            list.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.redirect.succeeded", list);
        } else if (args.length == 2) {
            Redirects redirect = Redirects.get(args[1]);
            if (redirect == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.redirect.redirect.notExist", args[1]);
                return;
            }
            Message redirectStateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.redirect.redirect." + (redirect.isEnabled() ? "enabled" : "disabled"), new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.redirect.redirect.succeeded", redirect, redirectStateMessage);
        } else if (args.length == 3) {
            if (!this.emptyRedirectState.hasPermissionToRun(player, true)) {
                return;
            }
            Redirects redirect = Redirects.get(args[1]);
            if (redirect == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.redirect.redirect.notExist", args[1]);
                return;
            }
            if (Main.isTrue(args[2])) {
                redirect.setEnabled(true);
                ColorTheme.sendSuccessTranslation(player, "tport.command.redirect.redirect.state.succeeded", redirect, ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.goodColor, "tport.command.redirect.redirect.enabled", new Object[0]));
            } else {
                redirect.setEnabled(false);
                ColorTheme.sendSuccessTranslation(player, "tport.command.redirect.redirect.state.succeeded", redirect, ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.badColor, "tport.command.redirect.redirect.disabled", new Object[0]));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport redirect [redirect] [state]");
        }
    }

    public static enum Redirects implements MessageUtils.MessageDescription
    {
        ConsoleFeedback(true, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.consoleFeedback.description", new Object[0]), SettingsInventories.settings_redirect_console_feedback_model, SettingsInventories.settings_redirect_console_feedback_grayed_model),
        TP_PLTP(true, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TP_PLTP.description", "/tp <player>", "/tport PLTP tp <player>"), SettingsInventories.settings_redirect_tp_pltp_model, SettingsInventories.settings_redirect_tp_pltp_grayed_model),
        Locate_FeatureTP(true, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.Locate_FeatureTP.description", "/locate structure <structure>", "/locate <structure>", "/tport FeatureTP search <feature>"), SettingsInventories.settings_redirect_locate_feature_tp_model, SettingsInventories.settings_redirect_locate_feature_tp_grayed_model),
        LocateBiome_BiomeTP(true, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.LocateBiome_BiomeTP.description", "/locate biome <biome>", "/locatebiome <biome>", "/tport BiomeTP whitelist <biome>"), SettingsInventories.settings_redirect_locate_biome_biome_tp_model, SettingsInventories.settings_redirect_locate_biome_biome_tp_grayed_model),
        Home_TPortHome(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.Home_TPortHome.description", "/home", "/tport home"), SettingsInventories.settings_redirect_home_tport_home_model, SettingsInventories.settings_redirect_home_tport_home_grayed_model),
        Back_TPortBack(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.Back_TPortBack.description", "/back", "/tport back"), SettingsInventories.settings_redirect_back_tport_back_model, SettingsInventories.settings_redirect_back_tport_back_grayed_model),
        TPA_PLTP_TP(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TPA_PLTP_TP.description", "/tpa <player>", "/tport pltp tp <player>"), SettingsInventories.settings_redirect_tpa_pltp_tp_model, SettingsInventories.settings_redirect_tpa_pltp_tp_grayed_model),
        TPAccept_Requests_accept(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TPAccept_Requests_accept.description", "/tpaccept [player]", "/tport requests accept [player]"), SettingsInventories.settings_redirect_tpaccept_requests_accept_model, SettingsInventories.settings_redirect_tpaccept_requests_accept_grayed_model),
        TPDeny_Requests_reject(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TPDeny_Requests_reject.description", "/tpdeny", "/tport requests reject [player]"), SettingsInventories.settings_redirect_tpdeny_requests_reject_model, SettingsInventories.settings_redirect_tpdeny_requests_reject_grayed_model),
        TPRevoke_Requests_revoke(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TPRevoke_Requests_revoke.description", "/tprevoke", "/tport requests revoke"), SettingsInventories.settings_redirect_tprevoke_requests_revoke_model, SettingsInventories.settings_redirect_tprevoke_requests_revoke_grayed_model),
        TPRandom_BiomeTP_random(false, ColorTheme.formatInfoTranslation("tport.command.redirect.redirect.TPRandom_BiomeTP_random.description", "/tprandom", "/randomtp", "/rtp", "/tport biomeTP random"), SettingsInventories.settings_redirect_tprandom_biome_tp_random_model, SettingsInventories.settings_redirect_tprandom_biome_tp_random_grayed_model);

        private boolean enabled;
        private final Message description;
        private final InventoryModel enabledModel;
        private final InventoryModel disabledModel;

        private Redirects(boolean defaultState, Message description, InventoryModel enabledModel, InventoryModel disabledModel) {
            this.enabled = defaultState;
            this.description = description;
            this.enabledModel = enabledModel;
            this.disabledModel = disabledModel;
        }

        public InventoryModel getModel() {
            return this.isEnabled() ? this.enabledModel : this.disabledModel;
        }

        public static void saveRedirects() {
            for (Redirects redirect : Redirects.values()) {
                Files.tportConfig.getConfig().set("redirects." + redirect.name(), (Object)redirect.enabled);
            }
            Files.tportConfig.saveConfig();
        }

        public static void loadRedirects() {
            for (Redirects redirect : Redirects.values()) {
                redirect.enabled = Files.tportConfig.getConfig().getBoolean("redirects." + redirect.name(), redirect.enabled);
            }
        }

        public static Redirects get(String name) {
            for (Redirects redirect : Redirects.values()) {
                if (!redirect.name().equalsIgnoreCase(name)) continue;
                return redirect;
            }
            return null;
        }

        public boolean isEnabled() {
            return Features.Feature.Redirects.isEnabled() && this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Message getDescription() {
            return this.description;
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name(), varColor));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }
    }
}

