/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Own
extends SubCommand {
    private final EmptyCommand emptyOwnTPort;

    public Own() {
        EmptyCommand emptyOwnTPortSafetyCheck = new EmptyCommand(){

            @Override
            public Message permissionsHover() {
                return ColorTheme.formatInfoTranslation("tport.command.own.tport.safetyCheck.permissionHover", "TPort.open", SafetyCheck.SafetyCheckSource.TPORT_OWN.getPermission(), "TPort.basic");
            }
        };
        emptyOwnTPortSafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        emptyOwnTPortSafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.own.tport.safetyCheck.commandDescription", new Object[0]));
        emptyOwnTPortSafetyCheck.setPermissions("TPort.own", SafetyCheck.SafetyCheckSource.TPORT_OWN.getPermission(), "TPort.basic");
        this.emptyOwnTPort = new EmptyCommand();
        this.emptyOwnTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        this.emptyOwnTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.own.tport.commandDescription", new Object[0]));
        this.emptyOwnTPort.setTabRunnable((args, player) -> Arrays.asList("true", "false"));
        this.emptyOwnTPort.addAction(emptyOwnTPortSafetyCheck);
        this.emptyOwnTPort.setPermissions("TPort.own", "TPort.basic");
        this.emptyOwnTPort.setTabRunnable((args, player) -> {
            if (emptyOwnTPortSafetyCheck.hasPermissionToRun(player, false)) {
                return Arrays.asList("true", "false");
            }
            return Collections.emptyList();
        });
        this.addAction(this.emptyOwnTPort);
        this.setPermissions(this.emptyOwnTPort.getPermissions());
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.own.commandDescription", new Object[0]));
    }

    public static List<String> getOwnTPorts(Player player) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().map(TPort::getName).collect(Collectors.toList());
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyOwnTPort.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Own.getOwnTPorts(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            TPortInventories.openTPortGUI(player.getUniqueId(), player);
            return;
        } else if (args.length == 2 || args.length == 3) {
            TPort tport;
            Boolean safetyCheckState;
            if (!this.emptyOwnTPort.hasPermissionToRun(player, true)) {
                return;
            }
            if (args.length == 3) {
                if (!SafetyCheck.SafetyCheckSource.TPORT_OWN.hasPermission(player, true)) return;
                safetyCheckState = Main.toBoolean(args[2]);
                if (safetyCheckState == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport own [TPort name] [true|false]");
                    return;
                }
            } else {
                safetyCheckState = SafetyCheck.SafetyCheckSource.TPORT_OWN.getState(player);
            }
            if ((tport = TPortManager.getTPort(player.getUniqueId(), args[1])) == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            tport.teleport(player, safetyCheckState, TPortAdvancement.Advancement_familiar);
            return;
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport own [TPort name] [safetyCheck]");
        }
    }
}

