/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.LookLocationSource;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class Look
extends SubCommand {
    private static final HashMap<String, LookRunnable> typeMap = new HashMap();

    public Look() {
        EmptyCommand emptyType = new EmptyCommand();
        emptyType.setCommandName("type", ArgumentType.OPTIONAL);
        emptyType.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.look.type.commandDescription", new Object[0]));
        emptyType.setPermissions("TPort.lookTP");
        this.addAction(emptyType);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.look.commandDescription", new Object[0]));
        this.setPermissions("TPort.lookTP");
        this.registerLookTypes();
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return typeMap.keySet();
    }

    public static boolean registerLookType(String name, LookRunnable run) {
        return typeMap.putIfAbsent(name.toLowerCase(), run) != null;
    }

    public void registerLookTypes() {
        typeMap.clear();
        Look.registerLookType("", player -> {
            Predicate<Entity> predicate = entity -> !entity.equals((Object)player) && !entity.equals((Object)player.getVehicle());
            RayTraceResult entityTrace = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 100.0, predicate);
            Entity entity2 = entityTrace != null ? entityTrace.getHitEntity() : null;
            RayTraceResult blockTrace = player.rayTraceBlocks(100.0, FluidCollisionMode.ALWAYS);
            Block block = blockTrace != null ? blockTrace.getHitBlock() : null;
            if (entity2 == null && block == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.notLooking", new Object[0]);
                return;
            }
            double entityDistance = Double.POSITIVE_INFINITY;
            if (entity2 != null) {
                entityDistance = player.getLocation().distance(entity2.getLocation());
            }
            double blockDistance = Double.POSITIVE_INFINITY;
            if (block != null) {
                blockDistance = player.getLocation().distance(block.getLocation());
            }
            if (entityDistance < blockDistance) {
                if (entity2.getType().equals((Object)EntityType.PLAYER)) {
                    Player p2 = (Player)entity2;
                    ColorTheme.sendInfoTranslation(player, "tport.command.look.pltp", new Object[0]);
                    TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"PLTP", "tp", p2.getName()});
                    TPortAdvancement.Advancement_LookMeInTheEyes.grant(player);
                } else {
                    TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(entity2.getType()));
                    TPEManager.requestTeleportPlayer(player, entity2.getLocation(), () -> {
                        ColorTheme.sendSuccessTranslation(player, "tport.command.look.entityTP", entity2.getType().toString());
                        TPortAdvancement.Advancement_LookMeInTheEyes.grant(player);
                    }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.entityTP.tpRequested", entity2.getType().toString(), delay, tickMessage, seconds, secondMessage));
                }
            } else if (!block.getType().equals((Object)Material.WATER) && !block.getType().equals((Object)Material.LAVA)) {
                Location blockLocation = block.getLocation();
                if (blockLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
                    blockLocation.add(blockTrace.getHitBlockFace().getDirection());
                } else if (blockLocation.getBlock().getType().isSolid()) {
                    blockLocation.add(0.0, 1.0, 0.0);
                }
                blockLocation.add(0.5, 0.1, 0.5);
                blockLocation.setPitch(player.getLocation().getPitch());
                blockLocation.setYaw(player.getLocation().getYaw());
                TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(block.getType()));
                TPEManager.requestTeleportPlayer(player, blockLocation, () -> ColorTheme.sendSuccessTranslation(player, "tport.command.look.blockTP", block.getType().toString()), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.blockTP.tpRequested", block.getType().toString(), delay, tickMessage, seconds, secondMessage));
            } else {
                Location location = block.getLocation().add(0.5, 1.1, 0.5);
                location.setPitch(player.getLocation().getPitch());
                location.setYaw(player.getLocation().getYaw());
                TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(block.getType()));
                TPEManager.requestTeleportPlayer(player, location, () -> ColorTheme.sendSuccessTranslation(player, "tport.command.look.fluidTP", block.getType().toString()), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.fluidTP.tpRequested", block.getType().toString(), delay, tickMessage, seconds, secondMessage));
            }
        });
        Look.registerLookType("entity", player -> {
            Predicate<Entity> predicate = entity -> !entity.equals((Object)player) && !entity.equals((Object)player.getVehicle());
            RayTraceResult rayTraceResult = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 100.0, predicate);
            if (rayTraceResult == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.entity.notFound", new Object[0]);
                return;
            }
            Entity entity2 = rayTraceResult.getHitEntity();
            if (entity2 == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.entity.notFound", new Object[0]);
                return;
            }
            if (entity2.getType().equals((Object)EntityType.PLAYER)) {
                Player lookedAtPlayer = (Player)entity2;
                ColorTheme.sendInfoTranslation(player, "tport.command.look.type.entity.pltp", new Object[0]);
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"PLTP", "tp", lookedAtPlayer.getName()});
                TPortAdvancement.Advancement_LookMeInTheEyes.grant(player);
            } else {
                TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(entity2.getType()));
                TPEManager.requestTeleportPlayer(player, entity2.getLocation(), () -> {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.look.type.entity.succeeded", entity2.getType().toString());
                    TPortAdvancement.Advancement_LookMeInTheEyes.grant(player);
                }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.type.entity.tpRequested", entity2.getType().toString(), delay, tickMessage, seconds, secondMessage));
            }
        });
        Look.registerLookType("block", player -> {
            RayTraceResult rayTraceResult = player.rayTraceBlocks(100.0, FluidCollisionMode.NEVER);
            if (rayTraceResult == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.block.notFound", new Object[0]);
                return;
            }
            Block block = rayTraceResult.getHitBlock();
            if (block == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.block.notFound", new Object[0]);
                return;
            }
            Location blockLocation = block.getLocation();
            if (blockLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
                blockLocation.add(rayTraceResult.getHitBlockFace().getDirection());
            } else if (blockLocation.getBlock().getType().isSolid()) {
                blockLocation.add(0.0, 1.0, 0.0);
            }
            blockLocation.add(0.5, 0.1, 0.5);
            blockLocation.setPitch(player.getLocation().getPitch());
            blockLocation.setYaw(player.getLocation().getYaw());
            TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(block.getType()));
            TPEManager.requestTeleportPlayer(player, blockLocation, () -> ColorTheme.sendSuccessTranslation(player, "tport.command.look.type.block.succeeded", block.getType().toString()), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.type.block.tpRequested", block.getType().toString(), delay, tickMessage, seconds, secondMessage));
        });
        Look.registerLookType("fluid", player -> {
            RayTraceResult rayTraceResult = player.rayTraceBlocks(100.0, FluidCollisionMode.ALWAYS);
            if (rayTraceResult == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.fluid.notFound", new Object[0]);
                return;
            }
            Block fluid = rayTraceResult.getHitBlock();
            if (fluid == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.fluid.notFound", new Object[0]);
                return;
            }
            if (!fluid.getType().equals((Object)Material.WATER) && !fluid.getType().equals((Object)Material.LAVA)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.look.type.fluid.notFound", new Object[0]);
                return;
            }
            Location location = fluid.getLocation().add(0.5, 1.1, 0.5);
            location.setPitch(player.getLocation().getPitch());
            location.setYaw(player.getLocation().getYaw());
            TeleportHistory.setLocationSource(player.getUniqueId(), new LookLocationSource(fluid.getType()));
            TPEManager.requestTeleportPlayer(player, location, () -> ColorTheme.sendSuccessTranslation(player, "tport.command.look.type.fluid.succeeded", fluid.getType().toString()), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.look.type.fluid.tpRequested", fluid.getType().toString(), delay, tickMessage, seconds, secondMessage));
        });
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.LookTP.isDisabled()) {
            Features.Feature.LookTP.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            if (!CooldownManager.LookTP.hasCooled(player, true)) {
                return;
            }
            LookRunnable looker = typeMap.get("");
            looker.look(player);
            CooldownManager.LookTP.update(player);
        } else if (args.length == 2) {
            LookRunnable looker = typeMap.get(args[1].toLowerCase());
            if (looker == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport look " + CommandTemplate.convertToArgs(this.getActions(), false));
                return;
            }
            if (!CooldownManager.LookTP.hasCooled(player, true)) {
                return;
            }
            looker.look(player);
            CooldownManager.LookTP.update(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport look " + CommandTemplate.convertToArgs(this.getActions(), true));
        }
    }

    @FunctionalInterface
    public static interface LookRunnable {
        public void look(Player var1);
    }
}

