/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.home.Get;
import com.spaceman.tport.commands.tport.home.Set;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class Home
extends SubCommand {
    private final EmptyCommand emptyHomeSafetyCheck = new EmptyCommand(){

        @Override
        public Message permissionsHover() {
            return ColorTheme.formatInfoTranslation("tport.command.home.safetyCheck.permissionHover", "TPort.open", SafetyCheck.SafetyCheckSource.TPORT_HOME.getPermission(), "TPort.basic");
        }

        @Override
        public String getName(String argument) {
            if (Main.isTrue(argument) || Main.isFalse(argument)) {
                return argument;
            }
            return "";
        }
    };

    public static boolean hasHome(Player player, boolean checkTPortValidity) {
        if (checkTPortValidity) {
            if (!Home.hasHome(player, false)) {
                return false;
            }
            return Home.getHome(player) != null;
        }
        return Files.tportData.getConfig().contains("tport." + String.valueOf(player.getUniqueId()) + ".home");
    }

    @Nullable
    public static TPort getHome(Player player) {
        String homeID = Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".home", null);
        if (homeID == null) {
            return null;
        }
        return TPortManager.getTPort(UUID.fromString(homeID));
    }

    public static void setHome(Player player, TPort home) {
        TPortAdvancement.Advancement_movingTruckComingThrough.grant(player);
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".home", (Object)home.getTportID().toString());
        Files.tportData.saveConfig();
    }

    public Home() {
        this.emptyHomeSafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        this.emptyHomeSafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.home.safetyCheck.commandDescription", new Object[0]));
        this.emptyHomeSafetyCheck.setRunnable((args, player) -> {
            Boolean safetyCheckState;
            if (!this.emptyHomeSafetyCheck.hasPermissionToRun(player, true)) {
                return;
            }
            if (!Home.hasHome(player, false)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.home.noHome", new Object[0]);
                return;
            }
            TPort tport = Home.getHome(player);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.home.homeNotFound", new Object[0]);
                return;
            }
            if (args.length == 2) {
                if (!SafetyCheck.SafetyCheckSource.TPORT_HOME.hasPermission(player, true)) return;
                safetyCheckState = Main.toBoolean(args[1]);
                if (safetyCheckState == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport home [true|false]");
                    return;
                }
            } else {
                safetyCheckState = SafetyCheck.SafetyCheckSource.TPORT_HOME.getState(player);
            }
            tport.teleport(player, safetyCheckState, TPortAdvancement.Advancement_homeSweetHome);
        });
        this.emptyHomeSafetyCheck.setPermissions("TPort.own", SafetyCheck.SafetyCheckSource.TPORT_HOME.getPermission(), "TPort.basic");
        this.addAction(this.emptyHomeSafetyCheck);
        this.addAction(new Get());
        this.addAction(new Set());
        this.setPermissions("TPort.home", "TPort.basic");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.home.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        Collection<String> tabList = super.tabList(player, args);
        if (!this.emptyHomeSafetyCheck.hasPermissionToRun(player, false)) {
            tabList.addAll(Arrays.asList("true", "false"));
        }
        return tabList;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            if (!Home.hasHome(player, false)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.home.noHome", new Object[0]);
                return;
            }
            TPort tport = Home.getHome(player);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.home.homeNotFound", new Object[0]);
                return;
            }
            tport.teleport(player, SafetyCheck.SafetyCheckSource.TPORT_HOME.getState(player), TPortAdvancement.Advancement_homeSweetHome);
        } else if (!CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport home " + CommandTemplate.convertToArgs(this.getActions(), true));
        }
    }
}

