/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.Language;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class GeneratePermFile
extends SubCommand {
    private final CommandTemplate template;
    private final EmptyCommand emptyFilterFile;

    public GeneratePermFile(CommandTemplate template) {
        this.template = template;
        this.emptyFilterFile = new EmptyCommand();
        this.emptyFilterFile.setCommandName("file type", ArgumentType.OPTIONAL);
        this.emptyFilterFile.setPermissions("tport.generatePermFile", "tport.admin");
        this.emptyFilterFile.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.generatePermFile.commandDescription", new Object[0]));
        EmptyCommand emptyFilter = new EmptyCommand();
        emptyFilter.setCommandName("filter none", ArgumentType.OPTIONAL);
        emptyFilter.setTabRunnable((args, player) -> List.of("csv", "json"));
        emptyFilter.setPermissions("tport.generatePermFile", "tport.admin");
        emptyFilter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.generatePermFile.commandDescription", new Object[0]));
        emptyFilter.addAction(this.emptyFilterFile);
        this.addAction(emptyFilter);
        this.setPermissions("tport.generatePermFile", "tport.admin");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.generatePermFile.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return List.of("true", "false");
    }

    @Override
    public void run(String[] args, Player player) {
        if (!this.emptyFilterFile.hasPermissionToRun(player, true)) {
            return;
        }
        if (args.length > 3) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport generatePermFile [filter none] [file type]");
            return;
        }
        boolean filterNone = false;
        if (args.length >= 2) {
            Boolean filter = Main.toBoolean(args[1]);
            if (filter == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport generatePermFile [true|false] [file type]");
                return;
            }
            if (filter.booleanValue()) {
                filterNone = true;
            }
        }
        String fileType = ".csv";
        int fileID = 1;
        if (args.length == 3) {
            if (args[2].equalsIgnoreCase("csv")) {
                fileType = ".csv";
                fileID = 1;
            } else if (args[2].equalsIgnoreCase("json")) {
                fileType = ".json";
                fileID = 2;
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport generatePermFile [filter none] [csv|json]");
                return;
            }
        }
        File outputFile = new File(Main.getInstance().getDataFolder(), "TPort permissions " + Main.getInstance().getDescription().getVersion() + fileType);
        switch (fileID) {
            case 1: {
                if (this.generateCSV(outputFile, filterNone)) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.generatePermFile.succeeded", new Object[0]);
                    break;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.generatePermFile.error", new Object[0]);
                break;
            }
            case 2: {
                if (this.generateJson(outputFile, filterNone)) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.generatePermFile.succeeded", new Object[0]);
                    break;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.generatePermFile.error", new Object[0]);
                break;
            }
            default: {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport generatePermFile [filter none] [csv|json]");
                return;
            }
        }
    }

    private boolean generateCSV(File outputFile, boolean filterNone) {
        LinkedHashMap<String, SubCommand> commandMap = this.template.collectActions();
        JsonObject lang = Language.getServerLang();
        try {
            FileWriter fileWriter = new FileWriter(outputFile);
            StringBuilder outputString = new StringBuilder();
            for (Map.Entry entry : ((HashMap)commandMap).entrySet()) {
                if (!((SubCommand)entry.getValue()).getPermissions().isEmpty()) {
                    String perm = ((SubCommand)entry.getValue()).permissionsHover().translateMessage(lang).translateString();
                    outputString.append((String)entry.getKey()).append(",").append(perm).append("\n");
                    continue;
                }
                if (filterNone) continue;
                outputString.append((String)entry.getKey()).append(",NONE").append("\n");
            }
            fileWriter.write(outputString.toString());
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException ioE) {
            return false;
        }
    }

    private boolean generateJson(File outputFile, boolean filterNone) {
        LinkedHashMap<String, SubCommand> commandMap = this.template.collectActions();
        JsonObject lang = Language.getServerLang();
        Gson gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject json = new JsonObject();
        try {
            FileWriter fileWriter = new FileWriter(outputFile);
            for (Map.Entry entry : ((HashMap)commandMap).entrySet()) {
                if (!((SubCommand)entry.getValue()).getPermissions().isEmpty()) {
                    String perm = ((SubCommand)entry.getValue()).permissionsHover().translateMessage(lang).translateString();
                    json.add((String)entry.getKey(), (JsonElement)new JsonPrimitive(perm));
                    continue;
                }
                if (filterNone) continue;
                json.add((String)entry.getKey(), (JsonElement)new JsonPrimitive("NONE"));
            }
            fileWriter.write(gsonBuilder.toJson((JsonElement)json));
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException ioE) {
            return false;
        }
    }
}

