/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.google.gson.JsonObject;
import com.spaceman.tport.Glow;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.featureTP.Mode;
import com.spaceman.tport.commands.tport.featureTP.Search;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.inventories.TPortInventories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FeatureTP
extends SubCommand {
    private final EmptyCommand empty = new EmptyCommand(){

        @Override
        public String getName(String argument) {
            return "";
        }
    };

    public FeatureTP() {
        this.empty.setCommandName("", ArgumentType.FIXED);
        this.empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.featureTP.commandDescription", new Object[0]));
        this.empty.setPermissions("TPort.featureTP.open");
        this.addAction(this.empty);
        this.addAction(new Mode());
        this.addAction(new Search());
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.FeatureTP.isDisabled()) {
            Features.Feature.FeatureTP.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            if (this.empty.hasPermissionToRun(player, true)) {
                TPortInventories.openFeatureTP(player);
            }
            return;
        }
        if (CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport featureTP " + CommandTemplate.convertToArgs(this.getActions(), true));
    }

    public static List<String> getFeatures() {
        try {
            return Main.getInstance().adapter.availableFeatures();
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("FeatureTP feature list", false);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            return new ArrayList<String>();
        }
    }

    public static List<String> getFeatures(World world) {
        try {
            return Main.getInstance().adapter.availableFeatures(world);
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("FeatureTP feature list", false);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            return new ArrayList<String>();
        }
    }

    public static List<Pair<String, List<String>>> getTags(World world) {
        try {
            return Main.getInstance().adapter.getFeatureTags(world);
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("FeatureTP tags", false);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            return new ArrayList<Pair<String, List<String>>>();
        }
    }

    public static Material getMaterial(String feature) {
        String materialName = switch (feature) {
            case "desert_pyramid" -> "SANDSTONE";
            case "end_city" -> "PURPUR_BLOCK";
            case "nether_fossil" -> "BONE_BLOCK";
            case "buried_treasure" -> "CHEST";
            case "bastion_remnant" -> "GILDED_BLACKSTONE";
            case "swamp_hut" -> "CAULDRON";
            case "jungle_pyramid", "jungle_temple" -> "TRIPWIRE_HOOK";
            case "igloo" -> "SNOW_BLOCK";
            case "fortress", "nether_fortress" -> "NETHER_BRICKS";
            case "mansion", "woodland_mansion" -> "TOTEM_OF_UNDYING";
            case "pillager_outpost" -> "CROSSBOW";
            case "monument", "ocean_monument" -> "PRISMARINE_BRICKS";
            case "stronghold" -> "END_PORTAL_FRAME";
            case "mineshaft", "mineshaft_mesa" -> "CHEST_MINECART";
            case "ocean_ruin_warm", "ocean_ruin_cold" -> "TRIDENT";
            case "shipwreck", "shipwreck_beached" -> "OAK_BOAT";
            case "ancient_city" -> "SCULK";
            case "trail_ruins" -> "SUSPICIOUS_GRAVEL";
            case "trial_chambers" -> "COPPER_GRATE";
            case "village_taiga", "village_snowy" -> "SPRUCE_DOOR";
            case "village_desert" -> "BIRCH_DOOR";
            case "village_plains" -> "OAK_DOOR";
            case "village_savanna" -> "ACACIA_DOOR";
            case "ruined_portal", "ruined_portal_swamp", "ruined_portal_nether", "ruined_portal_mountain", "ruined_portal_standard", "ruined_portal_jungle", "ruined_portal_ocean", "ruined_portal_desert" -> "CRYING_OBSIDIAN";
            default -> "DIAMOND_BLOCK";
        };
        return Main.getOrDefault(Material.getMaterial((String)materialName), Material.DIAMOND_BLOCK);
    }

    public static List<ItemStack> getItems(Player player, Set<String> featureSelection) {
        ColorTheme theme = ColorTheme.getTheme(player);
        ArrayList<ItemStack> features = new ArrayList<ItemStack>();
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        for (String string : FeatureTP.getFeatures(player.getWorld())) {
            Message selectedMessage;
            ItemStack item = new ItemStack(FeatureTP.getMaterial(string));
            boolean selected = false;
            if (featureSelection.contains(string)) {
                selected = true;
                selectedMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.tportInventories.openFeatureTP.feature.unselect", new Object[0]);
            } else {
                selectedMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.tportInventories.openFeatureTP.feature.select", new Object[0]);
            }
            Message featureLClick = ColorTheme.formatInfoTranslation("tport.tportInventories.openFeatureTP.feature.LClick", ClickType.LEFT, selectedMessage);
            Message featureRClick = ColorTheme.formatInfoTranslation("tport.tportInventories.openFeatureTP.feature.RClick", ClickType.RIGHT);
            if (playerLang != null) {
                featureLClick = MessageUtils.translateMessage(featureLClick, playerLang);
                featureRClick = MessageUtils.translateMessage(featureRClick, playerLang);
            }
            Message featureTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", string);
            MessageUtils.setCustomItemData(item, theme, featureTitle, Arrays.asList(featureLClick, featureRClick));
            ItemMeta im = item.getItemMeta();
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "feature"), PersistentDataType.STRING, (Object)string.toLowerCase());
            if (selected) {
                Glow.addGlow(im);
            }
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey featureKey = new NamespacedKey((Plugin)Main.getInstance(), "feature");
                if (pdc.has(featureKey, PersistentDataType.STRING)) {
                    String innerFeature;
                    Set innerFeatureSelection = fancyInventory.getData(TPortInventories.featureSelectionDataName);
                    if (innerFeatureSelection.contains(innerFeature = (String)pdc.get(featureKey, PersistentDataType.STRING))) {
                        innerFeatureSelection.remove(innerFeature);
                    } else {
                        innerFeatureSelection.add(innerFeature);
                    }
                    fancyInventory.setData(TPortInventories.featureSelectionDataName, innerFeatureSelection);
                    TPortInventories.openFeatureTP(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                }
            });
            FancyClickEvent.addCommand(im, ClickType.RIGHT, "tport featureTP search " + string);
            item.setItemMeta(im);
            if (selected) {
                features.add(0, item);
                continue;
            }
            features.add(item);
        }
        for (Pair pair : FeatureTP.getTags(player.getWorld())) {
            String m = switch (((String)pair.getLeft()).substring(1)) {
                case "ruined_portal" -> "CRYING_OBSIDIAN";
                case "dolphin_located" -> "DOLPHIN_SPAWN_EGG";
                case "on_woodland_explorer_maps", "on_ocean_explorer_maps", "on_treasure_maps", "on_trial_chambers_maps" -> "MAP";
                case "on_snowy_village_maps", "on_taiga_village_maps", "on_swamp_village_maps", "on_savanna_village_maps", "on_desert_village_maps", "on_jungle_village_maps", "on_plains_village_maps" -> "MAP";
                case "ocean_ruin" -> "TRIDENT";
                case "village" -> "EMERALD";
                case "eye_of_ender_located" -> "ENDER_EYE";
                case "mineshaft" -> "CHEST_MINECART";
                case "shipwreck" -> "OAK_BOAT";
                case "cats_spawn_as_black", "cats_spawn_in" -> "CAT_SPAWN_EGG";
                default -> "DIAMOND_BLOCK";
            };
            Material material = Main.getOrDefault(Material.getMaterial((String)m), Material.DIAMOND_BLOCK);
            ItemStack is = new ItemStack(material);
            List featureList = (List)pair.getRight();
            List<Message> lore = new LinkedList<Message>();
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.featureTP.getItems.list." + (featureList.size() == 1 ? "singular" : "multiple"), new Object[0]));
            Message lorePiece = new Message();
            boolean color = true;
            for (int i = 0; i < featureList.size(); ++i) {
                if (i % 2 == 0 && i != 0) {
                    lore.add(lorePiece);
                    lorePiece = new Message();
                }
                if (color) {
                    lorePiece.addText(TextComponent.textComponent((String)featureList.get(i), ColorTheme.ColorType.varInfoColor));
                } else {
                    lorePiece.addText(TextComponent.textComponent((String)featureList.get(i), ColorTheme.ColorType.varInfo2Color));
                }
                lorePiece.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.infoColor));
                color = !color;
            }
            lorePiece.removeLast();
            lore.add(lorePiece);
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.featureTP.getItems.selectFeatures.additive." + (featureList.size() == 1 ? "singular" : "multiple"), ClickType.LEFT));
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.featureTP.getItems.selectFeatures.overwrite." + (featureList.size() == 1 ? "singular" : "multiple"), ClickType.SHIFT_LEFT));
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.featureTP.getItems.selectFeatures.run", ClickType.RIGHT));
            if (playerLang != null) {
                lore = MessageUtils.translateMessage(lore, playerLang);
            }
            Message featureTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", pair.getLeft());
            MessageUtils.setCustomItemData(is, theme, featureTitle, lore);
            ItemMeta im = is.getItemMeta();
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "featureTag/name"), PersistentDataType.STRING, (Object)((String)pair.getLeft()));
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "featureTag/featuresFromPreset"), (PersistentDataType)PersistentDataType.LIST.strings(), (Object)((List)pair.getRight()));
            FancyClickEvent.addFunction(im, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey tagKey = new NamespacedKey((Plugin)Main.getInstance(), "featureTag/featuresFromPreset");
                if (pdc.has(tagKey, (PersistentDataType)PersistentDataType.LIST.strings())) {
                    List featuresFromPreset = (List)pdc.getOrDefault(tagKey, (PersistentDataType)PersistentDataType.LIST.strings(), new ArrayList());
                    Set<String> innerFeatureSelection = clickType == ClickType.LEFT ? fancyInventory.getData(TPortInventories.featureSelectionDataName) : new HashSet();
                    int originalSelectionSize = innerFeatureSelection.size();
                    List<String> availableFeatures = FeatureTP.getFeatures(whoClicked.getWorld());
                    for (String feature : featuresFromPreset) {
                        if (!availableFeatures.contains(feature)) continue;
                        innerFeatureSelection.add(feature);
                    }
                    if (originalSelectionSize == innerFeatureSelection.size()) {
                        ColorTheme.sendErrorTranslation(whoClicked, "tport.commands.tport.featureTP.getItems.selectFeatures.noBiomesLeft", new Object[0]);
                    }
                    fancyInventory.setData(TPortInventories.featureSelectionDataName, innerFeatureSelection);
                    TPortInventories.openFeatureTP(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    TPortAdvancement.Advancement_FeatureTP_OneIsNotEnough.grant(whoClicked);
                }
            }, ClickType.LEFT, ClickType.SHIFT_LEFT);
            FancyClickEvent.addCommand(im, ClickType.RIGHT, "tport featureTP search " + (String)pair.getLeft());
            is.setItemMeta(im);
            features.add(is);
        }
        return features;
    }

    @Nullable
    public static Location setSafeY(@Nonnull World world, int x, int z) {
        if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
            int originalX = x;
            int originalZ = z;
            int searches = 0;
            Random random = new Random();
            int spread = 10;
            for (int y = 1; y < world.getMaxHeight(); ++y) {
                Location tempFeet = new Location(world, (double)x, (double)y, (double)z);
                if (SafetyCheck.isSafe(tempFeet, true)) {
                    return tempFeet;
                }
                if (!tempFeet.getBlock().getType().equals((Object)Material.BEDROCK) || y <= 10) continue;
                if (searches == 20) {
                    return null;
                }
                x += (int)((double)random.nextInt(spread) - (double)spread * 0.5);
                z += (int)((double)random.nextInt(spread) - (double)spread * 0.5);
                y = 1;
                ++searches;
            }
            return new Location(world, (double)originalX, (double)(world.getHighestBlockYAt(originalX, originalZ) + 1), (double)originalZ);
        }
        int y = world.getHighestBlockYAt(x, z);
        Location location = new Location(world, (double)x, (double)(y + 1), (double)z);
        Random random = new Random();
        int spread = 10;
        int searches = 0;
        while (y <= 1 || !SafetyCheck.isSafe(location)) {
            if (searches == 20) {
                return null;
            }
            y = world.getHighestBlockYAt(x += (int)((double)random.nextInt(spread) - (double)spread * 0.5), z += (int)((double)random.nextInt(spread) - (double)spread * 0.5));
            location = new Location(world, (double)x, (double)(y + 1), (double)z);
            ++searches;
        }
        return location;
    }
}

