/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.delay.Get;
import com.spaceman.tport.commands.tport.delay.Handler;
import com.spaceman.tport.commands.tport.delay.Set;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Delay
extends SubCommand {
    public Delay() {
        this.addAction(new Handler());
        this.addAction(new Set());
        this.addAction(new Get());
    }

    public static void setPermissionBased(boolean state) {
        Files.tportConfig.getConfig().set("delay.permission", (Object)state);
        Files.tportConfig.saveConfig();
    }

    public static boolean isPermissionBased() {
        return Files.tportConfig.getConfig().getBoolean("delay.permission", false);
    }

    public static int delayTime(Player player) {
        if (Delay.isPermissionBased()) {
            for (PermissionAttachmentInfo p : player.getEffectivePermissions()) {
                if (!p.getPermission().toLowerCase().startsWith("tport.delay.time.")) continue;
                try {
                    return Integer.parseInt(p.getPermission().toLowerCase().replace("tport.delay.time.", ""));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        } else {
            return Files.tportConfig.getConfig().getInt("delay.time." + String.valueOf(player.getUniqueId()), 0);
        }
        return 0;
    }

    public static int delayTime(UUID uuid) {
        if (Delay.isPermissionBased()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return 0;
            }
            for (PermissionAttachmentInfo p : player.getEffectivePermissions()) {
                if (!p.getPermission().toLowerCase().startsWith("tport.delay.time.")) continue;
                try {
                    return Integer.parseInt(p.getPermission().toLowerCase().replace("tport.delay.time.", ""));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        } else {
            return Files.tportConfig.getConfig().getInt("delay.time." + String.valueOf(uuid), 0);
        }
        return 0;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 1 && CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay <handler|set|get>");
    }
}

