/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Back;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.biomeTP.Accuracy;
import com.spaceman.tport.commands.tport.biomeTP.Blacklist;
import com.spaceman.tport.commands.tport.biomeTP.Mode;
import com.spaceman.tport.commands.tport.biomeTP.Preset;
import com.spaceman.tport.commands.tport.biomeTP.Random;
import com.spaceman.tport.commands.tport.biomeTP.Whitelist;
import com.spaceman.tport.commands.tport.featureTP.Mode;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.BiomeLocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.metrics.BiomeSearchCounter;
import com.spaceman.tport.tpEvents.TPEManager;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class BiomeTP
extends SubCommand {
    public static boolean legacyBiomeTP = false;
    private final EmptyCommand empty = new EmptyCommand(){

        @Override
        public String getName(String argument) {
            return "";
        }
    };
    public static int randomTPTries = 100;

    public BiomeTP() {
        this.empty.setCommandName("", ArgumentType.FIXED);
        this.empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.commandDescription", new Object[0]));
        this.empty.setPermissions("TPort.biomeTP.open");
        this.addAction(this.empty);
        this.addAction(new Whitelist());
        this.addAction(new Blacklist());
        this.addAction(Preset.getInstance());
        this.addAction(Random.getInstance());
        this.addAction(new Accuracy());
        this.addAction(new Mode());
        this.registerBiomeTPPresets();
    }

    public static List<String> availableBiomes() {
        if (!legacyBiomeTP) {
            try {
                return Main.getInstance().adapter.availableBiomes();
            }
            catch (Throwable ex) {
                Features.Feature.printSmallNMSErrorInConsole("BiomeTP biome list", true);
                if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                    ex.printStackTrace();
                }
                legacyBiomeTP = true;
            }
        }
        return StreamSupport.stream(Registry.BIOME.spliterator(), false).map(b -> b.getKey().getKey().toLowerCase()).toList();
    }

    public static List<String> availableBiomes(World world) {
        if (!legacyBiomeTP) {
            try {
                return Main.getInstance().adapter.availableBiomes(world);
            }
            catch (Throwable ex) {
                Features.Feature.printSmallNMSErrorInConsole("BiomeTP per world biome list", true);
                if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                    ex.printStackTrace();
                }
                legacyBiomeTP = true;
            }
        }
        return BiomeTP.availableBiomes();
    }

    @Nullable
    public static Pair<Location, String> biomeFinder(Player player, List<String> biomes, @Nonnull Location startLocation, Accuracy.AccuracySettings accuracy) {
        if (!legacyBiomeTP) {
            try {
                return Main.getInstance().adapter.biomeFinder(player, biomes, startLocation, accuracy);
            }
            catch (Throwable ex) {
                Features.Feature.printSmallNMSErrorInConsole("BiomeTP biome finder", true);
                if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                    ex.printStackTrace();
                }
                legacyBiomeTP = true;
            }
        }
        return BiomeTP.legacyBiomeTP(player, biomes, startLocation, accuracy);
    }

    private static Pair<Location, String> legacyBiomeTP(Player player, List<String> biomes, @Nonnull Location startLocation, Accuracy.AccuracySettings accuracy) {
        int startX = startLocation.getBlockX();
        int startZ = startLocation.getBlockZ();
        World world = startLocation.getWorld();
        if (world == null) {
            return null;
        }
        Rectangle searchArea = Main.getSearchArea(player);
        int size = accuracy.getRange();
        List<Integer> yLevels = accuracy.getYLevels();
        int increment = accuracy.getIncrement();
        int quartSize = size >> 2;
        int quartX = startX >> 2;
        int quartZ = startZ >> 2;
        for (int squareSize = 0; squareSize <= quartSize; squareSize += increment) {
            for (int zOffset = -squareSize; zOffset <= squareSize; zOffset += increment) {
                boolean zEnd = Math.abs(zOffset) == squareSize;
                for (int xOffset = -squareSize; xOffset <= squareSize; xOffset += increment) {
                    int newZ;
                    int newX;
                    boolean xEnd;
                    boolean bl = xEnd = Math.abs(zOffset) == squareSize;
                    if (!zEnd && !xEnd || !searchArea.contains(newX = quartX + xOffset << 2, newZ = quartZ + zOffset << 2)) continue;
                    for (int y : yLevels) {
                        Location testLocation = new Location(world, (double)newX, (double)y, (double)newZ);
                        Biome biome = world.getBiome(testLocation);
                        if (!biomes.stream().anyMatch(b -> biome.name().equalsIgnoreCase((String)b))) continue;
                        return new Pair<Location, String>(testLocation, biome.name());
                    }
                }
            }
        }
        return null;
    }

    public static void randomTP(Player player) {
        for (int i = 0; i < randomTPTries; ++i) {
            Location location = Main.getRandomLocation(player);
            location = FeatureTP.setSafeY(player.getWorld(), location.getBlockX(), location.getBlockZ());
            if (location == null) continue;
            location.add(0.5, 0.1, 0.5);
            location.setPitch(player.getLocation().getPitch());
            location.setYaw(player.getLocation().getYaw());
            Back.prevTPorts.put(player.getUniqueId(), new Back.PrevTPort(Back.PrevType.BIOME, "biomeLoc", (Object)location, "prevLoc", (Object)player.getLocation(), "biomeName", (Object)"Random"));
            TeleportHistory.setLocationSource(player.getUniqueId(), new BiomeLocationSource("random"));
            TPEManager.requestTeleportPlayer(player, location, () -> {
                ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.biomeTP.random.succeeded", new Object[0]);
                TPortAdvancement.Advancement_BiomeTP_IDontCare.grant(player);
            }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.biomeTP.randomTP.succeededRequested", delay, tickMessage, seconds, secondMessage));
            CooldownManager.BiomeTP.update(player);
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.random.couldNotFindLocation", randomTPTries);
    }

    public static void biomeTP(Player player, Mode.WorldSearchMode mode, List<String> biomes) {
        BiomeSearchCounter.add(biomes);
        Accuracy.AccuracySettings accuracySettings = Accuracy.getDefaultAccuracySettings();
        if (biomes.size() == 1) {
            ColorTheme.sendInfoTranslation(player, "tport.command.biomeTP.searchingForBiome", BiomeTP.biomesToStringSearch(biomes), accuracySettings);
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.biomeTP.searchingForBiomes", BiomeTP.biomesToStringSearch(biomes), accuracySettings);
        }
        Pair<Location, String> biomeLocation = BiomeTP.biomeFinder(player, biomes, mode.getLoc(player), accuracySettings);
        CooldownManager.BiomeTP.update(player);
        if (biomeLocation == null) {
            if (biomes.size() == 1) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.couldNotFindBiome", BiomeTP.biomesToStringError(biomes), accuracySettings);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.couldNotFindBiomes", BiomeTP.biomesToStringError(biomes), accuracySettings);
            }
        } else {
            Location biomeLoc = biomeLocation.getLeft();
            biomeLoc = FeatureTP.setSafeY(player.getWorld(), biomeLoc.getBlockX(), biomeLoc.getBlockZ());
            if (biomeLoc == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.noSafeLocationFound", new Object[0]);
                return;
            }
            biomeLoc.add(0.5, 0.1, 0.5);
            biomeLoc.setPitch(player.getLocation().getPitch());
            biomeLoc.setYaw(player.getLocation().getYaw());
            Back.prevTPorts.put(player.getUniqueId(), new Back.PrevTPort(Back.PrevType.BIOME, "biomeLoc", (Object)biomeLoc, "prevLoc", (Object)player.getLocation(), "biomeName", (Object)biomeLocation.getRight()));
            TeleportHistory.setLocationSource(player.getUniqueId(), new BiomeLocationSource(biomeLocation.getRight()));
            Message biomeName = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(biomeLocation.getRight()));
            TPEManager.requestTeleportPlayer(player, biomeLoc, () -> {
                ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.biomeTP.succeeded", biomeName);
                if (biomes.size() == 1) {
                    TPortAdvancement.Advancement_BiomeTP_Certainty.grant(player);
                } else {
                    TPortAdvancement.Advancement_BiomeTP_Surprise.grant(player);
                }
            }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.biomeTP.succeededRequested", biomeName, delay, tickMessage, seconds, secondMessage));
        }
    }

    private static Message biomesToStringError(List<String> biomes) {
        Message biomeList = new Message();
        int listSize = biomes.size();
        boolean color = true;
        for (int i = 0; i < listSize; ++i) {
            String biome = biomes.get(i).toLowerCase();
            if (color) {
                biomeList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varErrorColor, "%s", new BiomeEncapsulation(biome)));
            } else {
                biomeList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varError2Color, ColorTheme.ColorType.varError2Color, "%s", new BiomeEncapsulation(biome)));
            }
            if (i + 2 == listSize) {
                biomeList.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.listBiomes.error.lastDelimiter", new Object[0]));
            } else {
                biomeList.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.listBiomes.error.delimiter", new Object[0]));
            }
            color = !color;
        }
        biomeList.removeLast();
        return biomeList;
    }

    private static Message biomesToStringSearch(List<String> biomes) {
        Message biomeList = new Message();
        biomeList.addText("");
        int listSize = biomes.size();
        boolean color = true;
        for (int i = 0; i < listSize; ++i) {
            String biome = biomes.get(i).toLowerCase();
            if (color) {
                biomeList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(biome)));
            } else {
                biomeList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", new BiomeEncapsulation(biome)));
            }
            if (i + 2 == listSize) {
                biomeList.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.listBiomes.info.lastDelimiter", new Object[0]));
            } else {
                biomeList.addMessage(ColorTheme.formatInfoTranslation("tport.command.biomeTP.listBiomes.info.delimiter", new Object[0]));
            }
            color = !color;
        }
        biomeList.removeLast();
        return biomeList;
    }

    private void registerBiomeTPPresets() {
        BiomePreset.registerPreset("Land", Arrays.asList("OCEAN", "WARM_OCEAN", "LUKEWARM_OCEAN", "COLD_OCEAN", "FROZEN_OCEAN", "DEEP_OCEAN", "DEEP_LUKEWARM_OCEAN", "DEEP_COLD_OCEAN", "DEEP_FROZEN_OCEAN", "RIVER", "FROZEN_RIVER"), false, Material.GRASS_BLOCK);
        BiomePreset.registerPreset("Water", Arrays.asList("OCEAN", "WARM_OCEAN", "LUKEWARM_OCEAN", "COLD_OCEAN", "FROZEN_OCEAN", "DEEP_OCEAN", "DEEP_LUKEWARM_OCEAN", "DEEP_COLD_OCEAN", "DEEP_FROZEN_OCEAN", "RIVER", "FROZEN_RIVER"), true, Material.WATER_BUCKET);
        BiomePreset.registerPreset("The_End", Arrays.asList("END_BARRENS", "END_HIGHLANDS", "END_MIDLANDS", "THE_END", "SMALL_END_ISLANDS"), true, Material.END_STONE);
        BiomePreset.registerPreset("Nether", Arrays.asList("NETHER_WASTES", "BASALT_DELTAS", "CRIMSON_FOREST", "WARPED_FOREST", "SOUL_SAND_VALLEY"), true, Material.NETHERRACK);
        BiomePreset.registerPreset("Trees", Arrays.asList("FOREST", "CHERRY_GROVE", "WINDSWEPT_FOREST", "DARK_FOREST", "SAVANNA", "SAVANNA_PLATEAU", "WINDSWEPT_SAVANNA", "JUNGLE", "SPARSE_JUNGLE", "BIRCH_FOREST", "OLD_GROWTH_BIRCH_FOREST", "TAIGA", "OLD_GROWTH_SPRUCE_TAIGA", "OLD_GROWTH_PINE_TAIGA"), true, Material.OAK_WOOD);
    }

    public static Material getMaterial(String biome) {
        String materialName = switch (biome.toUpperCase()) {
            case "OCEAN", "RIVER", "DEEP_OCEAN", "LUKEWARM_OCEAN", "COLD_OCEAN", "DEEP_LUKEWARM_OCEAN", "DEEP_COLD_OCEAN" -> "WATER_BUCKET";
            case "PLAINS", "WINDSWEPT_HILLS", "MEADOW" -> "GRASS_BLOCK";
            case "DESERT", "BEACH" -> "SAND";
            case "FOREST", "WINDSWEPT_FOREST" -> "OAK_LOG";
            case "TAIGA", "OLD_GROWTH_PINE_TAIGA", "OLD_GROWTH_SPRUCE_TAIGA" -> "SPRUCE_LOG";
            case "SWAMP" -> "LILY_PAD";
            case "NETHER_WASTES" -> "NETHERRACK";
            case "THE_END", "SMALL_END_ISLANDS", "END_MIDLANDS", "END_HIGHLANDS", "END_BARRENS" -> "END_STONE";
            case "FROZEN_OCEAN", "FROZEN_RIVER", "DEEP_FROZEN_OCEAN" -> "ICE";
            case "ICE_SPIKES", "FROZEN_PEAKS" -> "PACKED_ICE";
            case "SNOWY_PLAINS", "SNOWY_BEACH", "SNOWY_TAIGA" -> "SNOW";
            case "MUSHROOM_FIELDS" -> "RED_MUSHROOM_BLOCK";
            case "JUNGLE", "SPARSE_JUNGLE" -> "JUNGLE_LOG";
            case "BAMBOO_JUNGLE" -> "BAMBOO";
            case "STONY_SHORE", "STONY_PEAKS" -> "STONE";
            case "BIRCH_FOREST", "OLD_GROWTH_BIRCH_FOREST" -> "BIRCH_LOG";
            case "DARK_FOREST" -> "DARK_OAK_LOG";
            case "SAVANNA", "SAVANNA_PLATEAU", "WINDSWEPT_SAVANNA" -> "ACACIA_LOG";
            case "BADLANDS", "WOODED_BADLANDS", "ERODED_BADLANDS" -> "TERRACOTTA";
            case "WARM_OCEAN" -> "BRAIN_CORAL_BLOCK";
            case "THE_VOID" -> "BARRIER";
            case "SUNFLOWER_PLAINS" -> "SUNFLOWER";
            case "WINDSWEPT_GRAVELLY_HILLS" -> "GRAVEL";
            case "FLOWER_FOREST" -> "ROSE_BUSH";
            case "SOUL_SAND_VALLEY" -> "SOUL_SAND";
            case "CRIMSON_FOREST" -> "CRIMSON_NYLIUM";
            case "WARPED_FOREST" -> "WARPED_NYLIUM";
            case "BASALT_DELTAS" -> "BASALT";
            case "DRIPSTONE_CAVES" -> "POINTED_DRIPSTONE";
            case "LUSH_CAVES" -> "GLOW_BERRIES";
            case "GROVE", "JAGGED_PEAKS" -> "SNOW_BLOCK";
            case "SNOWY_SLOPES" -> "POWDER_SNOW_BUCKET";
            case "MANGROVE_SWAMP" -> "MANGROVE_LOG";
            case "DEEP_DARK" -> "SCULK";
            case "CHERRY_GROVE" -> "CHERRY_LOG";
            case "PALE_GARDEN" -> "PALE_OAK_LOG";
            default -> "DIAMOND_BLOCK";
        };
        return Main.getOrDefault(Material.getMaterial((String)materialName), Material.DIAMOND_BLOCK);
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.BiomeTP.isDisabled()) {
            Features.Feature.BiomeTP.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            if (!this.empty.hasPermissionToRun(player, true)) {
                return;
            }
            TPortInventories.openBiomeTP(player);
        } else if (!CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP " + CommandTemplate.convertToArgs(this.getActions(), true));
        }
    }
}

