/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class Adapter
extends SubCommand {
    public static HashMap<String, String> adapters = new HashMap();
    public static final String automatic = "automatic";
    private final EmptyCommand emptyAdapter = new EmptyCommand();

    public static boolean registerAdapter(String name, String path) {
        if (name.equalsIgnoreCase(automatic)) {
            throw new IllegalArgumentException("Adapter name can not be 'automatic'");
        }
        name = name.toLowerCase();
        try {
            Class.forName(path);
        }
        catch (ClassNotFoundException cnfe) {
            Main.getInstance().getLogger().log(Level.WARNING, "Adapter " + name + " was not found");
            return false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!adapters.containsKey(name)) {
            adapters.put(name, path);
            return true;
        }
        return false;
    }

    private static TPortAdapter initAdapter(String path) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (path == null) {
            throw new ClassNotFoundException();
        }
        return (TPortAdapter)Class.forName(path).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static String getSelectedAdapter() {
        return Files.tportConfig.getConfig().getString("tport.adapter", automatic).toLowerCase();
    }

    public static String getLoadedAdapter() {
        return Main.getInstance().adapter.getAdapterName();
    }

    private static TPortAdapter loadAdaptive() {
        TPortAdapter adaptive = null;
        try {
            adaptive = Adapter.initAdapter(adapters.get("adaptive"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return adaptive;
    }

    public static void loadAdapter(@Nullable Player player) {
        TPortAdapter adapter;
        block11: {
            String adapterName = Files.tportConfig.getConfig().getString("tport.adapter", automatic).toLowerCase();
            String serverVersion = ReflectionManager.getServerVersion();
            if (adapterName.equals(automatic)) {
                adapterName = serverVersion.toLowerCase();
            }
            adapter = null;
            try {
                adapter = Adapter.initAdapter(adapters.get(adapterName));
            }
            catch (ClassNotFoundException cnfe) {
                if (player == null) {
                    Main.getInstance().getLogger().log(Level.WARNING, "Adapter '" + adapterName + "' was not found, attempting to load 'adaptive'");
                } else {
                    ColorTheme.sendErrorTranslation(player, "tport.command.adapter.adapter.notFound", adapterName, "adaptive");
                }
            }
            catch (Throwable e) {
                if (player == null) {
                    Main.getInstance().getLogger().log(Level.WARNING, "Adapter '" + adapterName + "' is not loading on this server, attempting to load 'adaptive'");
                } else {
                    ColorTheme.sendErrorTranslation(player, "tport.command.adapter.adapter.notLoading", adapterName, "adaptive");
                }
                if (!Features.Feature.PrintErrorsInConsole.isEnabled()) break block11;
                e.printStackTrace();
            }
        }
        if (adapter == null) {
            adapter = Adapter.loadAdaptive();
        }
        Main.getInstance().adapter = adapter;
        if (player == null) {
            Main.getInstance().getLogger().log(Level.INFO, "Successfully loaded adapter '" + Main.getInstance().adapter.getAdapterName() + "'");
        } else {
            ColorTheme.sendSuccessTranslation(player, "tport.command.adapter.adapter.loaded", Main.getInstance().adapter.getAdapterName());
        }
    }

    public Adapter() {
        this.emptyAdapter.setCommandName("adapter", ArgumentType.OPTIONAL);
        this.emptyAdapter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.adapter.adapter.commandDescription", new Object[0]));
        this.emptyAdapter.setPermissions("TPort.adapter", "TPort.admin");
        this.addAction(this.emptyAdapter);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.adapter.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>(adapters.keySet());
        list.add(automatic);
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            String setTo = Files.tportConfig.getConfig().getString("tport.adapter", automatic).toLowerCase();
            ColorTheme.sendInfoTranslation(player, "tport.command.adapter.setTo", setTo);
            ColorTheme.sendInfoTranslation(player, "tport.command.adapter.name", Main.getInstance().adapter.getAdapterName());
        } else if (args.length == 2) {
            if (!this.emptyAdapter.hasPermissionToRun(player, true)) {
                return;
            }
            if (adapters.containsKey(args[1].toLowerCase()) || automatic.equalsIgnoreCase(args[1])) {
                Files.tportConfig.getConfig().set("tport.adapter", (Object)args[1]);
                Files.tportConfig.saveConfig();
                Adapter.loadAdapter(player);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.adapter.adapter.adapterNotExist", args[1].toLowerCase());
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport adapter [adapter]");
        }
    }
}

