/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commandHandler;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;

public abstract class SubCommand {
    protected static final String descriptionNotGiven = "tport.commandHandler.subCommand.descriptionNotGiven";
    private final ArrayList<SubCommand> actions = new ArrayList();
    private ArgumentType argumentType = ArgumentType.FIXED;
    private String commandName = this.getName("");
    private Message commandDescription = ColorTheme.formatErrorTranslation("tport.commandHandler.subCommand.descriptionNotGiven", new Object[0]);
    private boolean linked = false;
    private List<String> permissions = new ArrayList<String>();
    private boolean permissionsOR = true;

    public static String lowerCaseFirst(String string) {
        return string == null || string.isEmpty() ? "" : Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public void addAction(SubCommand subCommand) {
        this.actions.add(subCommand);
    }

    public boolean removeAction(SubCommand subCommand) {
        return this.actions.remove(subCommand);
    }

    public SubCommand removeAction(String actionName) {
        for (SubCommand sub : this.actions) {
            if (!sub.getName(actionName).equals(actionName) || !this.actions.remove(sub)) continue;
            return sub;
        }
        return null;
    }

    public ArrayList<SubCommand> getActions() {
        return new ArrayList<SubCommand>(this.actions);
    }

    public SubCommand getAction(String action) {
        return this.getAction(action, null);
    }

    public SubCommand getAction(String action, SubCommand def) {
        for (SubCommand subCommand : this.getActions()) {
            if (!subCommand.getName(action).equalsIgnoreCase(action)) continue;
            return subCommand;
        }
        return def;
    }

    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (SubCommand subCommand : this.actions) {
            list.add(subCommand.getName(""));
        }
        return list;
    }

    public void setLinked() {
        this.linked = true;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public Message getCommandDescription() {
        return (Message)this.commandDescription.clone();
    }

    public void setCommandDescription(Message commandDescription) {
        this.commandDescription = commandDescription;
    }

    public void setCommandDescription(TextComponent ... textComponents) {
        this.setCommandDescription(new Message(textComponents));
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(ArgumentType argumentType) {
        this.argumentType = argumentType;
    }

    public void setCommandName(String commandName, ArgumentType argumentType) {
        this.setCommandName(commandName);
        this.setArgumentType(argumentType);
    }

    public String getName(String arg) {
        return SubCommand.lowerCaseFirst(this.getClass().getSimpleName());
    }

    public List<String> getAliases() {
        return new ArrayList<String>();
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
        PluginManager pm = Bukkit.getPluginManager();
        for (String permission : permissions) {
            try {
                pm.addPermission(new Permission(permission));
            }
            catch (Exception exception) {}
        }
    }

    public void setPermissions(String ... permissions) {
        this.setPermissions(Arrays.asList(permissions));
    }

    public boolean permissionsOR() {
        return this.permissionsOR;
    }

    public void permissionsOR(boolean OR) {
        this.permissionsOR = OR;
    }

    public boolean hasPermissionToRun(Player player, boolean sendMessage) {
        return PermissionHandler.hasPermission(player, sendMessage, this.permissionsOR, this.permissions);
    }

    public Message permissionsHover() {
        if (this.permissions.size() == 1) {
            return ColorTheme.formatInfoTranslation("tport.commandHandler.subCommand.permissionHover.singular", this.permissions.get(0));
        }
        Message message = new Message();
        message.addText(TextComponent.textComponent(this.permissions.get(0), ColorTheme.ColorType.varInfoColor).setInsertion(this.permissions.get(0)));
        boolean color = false;
        for (int i = 1; i < this.permissions.size() - 1; ++i) {
            String permission = this.permissions.get(i);
            message.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.infoColor));
            message.addText(TextComponent.textComponent(permission, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color).setInsertion(permission));
            color = !color;
        }
        message.addWhiteSpace();
        message.addMessage(ColorTheme.formatInfoTranslation("tport.permissions.permissionHandler." + (this.permissionsOR ? "or" : "and"), new Object[0]));
        message.addWhiteSpace();
        String permission = this.permissions.get(this.permissions.size() - 1);
        message.addText(TextComponent.textComponent(permission, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color).setInsertion(permission));
        return ColorTheme.formatInfoTranslation("tport.commandHandler.subCommand.permissionHover.multiple", message);
    }

    public abstract void run(String[] var1, Player var2);
}

