/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commandHandler;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commandHandler.customRunnables.RunRunnable;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class HelpCommand
extends SubCommand {
    private int listSize = 10;
    private final CommandTemplate template;
    private final Message commandMessage;
    private final List<String> extraHelp = new ArrayList<String>();

    public HelpCommand(final CommandTemplate template, @Nullable Message commandMessage, boolean shortenFirst) {
        this.template = template;
        if (commandMessage == null) {
            commandMessage = ColorTheme.formatInfoTranslation("tport.command.help.defaultDescription", new Object[0]);
        }
        this.commandMessage = commandMessage;
        EmptyCommand commandPage = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                try {
                    Integer.parseInt(argument);
                    return argument;
                }
                catch (NumberFormatException nfe) {
                    return "";
                }
            }
        };
        commandPage.setCommandName("page", ArgumentType.REQUIRED);
        commandPage.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.help.page.commandDescription", new Object[0]));
        commandPage.setRunnable((args, player) -> {
            int page;
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.help.page.notANumber", args[1]);
                return;
            }
            LinkedHashMap<String, SubCommand> commandMap = template.collectActions();
            ArrayList commandArrayList = new ArrayList(((HashMap)commandMap).keySet());
            int maxPages = commandArrayList.size() / this.listSize;
            if (commandArrayList.size() % this.listSize != 0) {
                ++maxPages;
            }
            if (page > maxPages) {
                page = maxPages;
            }
            if (page <= 0) {
                page = 1;
            }
            int startIndex = (page - 1) * this.listSize;
            ColorTheme theme = ColorTheme.getTheme(player);
            Message buttons = new Message();
            if (commandArrayList.size() > this.listSize) {
                buttons.addText(TextComponent.textComponent(" (", theme.getInfoColor()));
                if (page != 1) {
                    HoverEvent backwardHover = new HoverEvent(TextComponent.textComponent("/" + template.getName() + " help " + (page - 1), theme.getInfoColor()));
                    ClickEvent backwardClick = ClickEvent.runCommand("/" + template.getName() + " help " + (page - 1));
                    buttons.addText(TextComponent.textComponent("<-", theme.getVarInfoColor(), backwardHover, backwardClick));
                }
                if (page < maxPages) {
                    if (page != 1) {
                        buttons.addText(" ");
                    }
                    HoverEvent forwardHover = new HoverEvent(TextComponent.textComponent("/" + template.getName() + " help " + (page + 1), theme.getInfoColor()));
                    ClickEvent forwardClick = ClickEvent.runCommand("/" + template.getName() + " help " + (page + 1));
                    buttons.addText(TextComponent.textComponent("->", theme.getVarInfoColor(), forwardHover, forwardClick));
                }
                buttons.addText(TextComponent.textComponent(")", theme.getInfoColor()));
            }
            Message commands = new Message();
            boolean color = true;
            for (int i = startIndex; i < startIndex + this.listSize && i < commandArrayList.size(); ++i) {
                String command = (String)commandArrayList.get(i);
                SubCommand subCommand = (SubCommand)((HashMap)commandMap).get(command);
                TextComponent commandComponent = this.commandToComponent(command, subCommand, player, color);
                commands.addText(commandComponent);
                commands.addNewLine();
                color = !color;
            }
            commands.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.help.page.succeeded", "/" + template.getName(), page, buttons, commands);
        });
        EmptyCommand commandHelp = new EmptyCommand(this){
            final /* synthetic */ HelpCommand this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getName(String argument) {
                return template.getName();
            }
        };
        commandHelp.setCommandName(template.getName() + " command", ArgumentType.REQUIRED);
        commandHelp.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.help.command.commandDescription", new Object[0]));
        commandHelp.setRunnable((args, player) -> {
            if (shortenFirst && args.length == 2) {
                String command = "/" + StringUtils.join((Object[])args, (String)" ", (int)1, (int)args.length);
                Message commands = new Message();
                boolean color = true;
                for (SubCommand subCommand : template.getActions()) {
                    TextComponent commandComponent;
                    String clickCommand;
                    if (subCommand.getActions().isEmpty()) {
                        clickCommand = "/" + template.getName() + " " + subCommand.getCommandName();
                        commandComponent = this.commandToComponent(clickCommand, subCommand, player, color);
                    } else {
                        clickCommand = "/" + template.getName() + " help " + template.getName() + " " + subCommand.getCommandName();
                        if (subCommand.getCommandDescription().getText().get(0).getText().equals("tport.commandHandler.subCommand.descriptionNotGiven")) {
                            EmptyCommand descriptionHack = new EmptyCommand();
                            descriptionHack.setCommandDescription(ColorTheme.formatInfoTranslation("tport.commandHandler.subCommand.shorten.generalDescription", clickCommand));
                            commandComponent = this.commandToComponent("/" + template.getName() + " " + subCommand.getCommandName() + " <...>", descriptionHack, player, color);
                        } else {
                            commandComponent = this.commandToComponent("/" + template.getName() + " " + subCommand.getCommandName() + " [...]", subCommand, player, color);
                        }
                    }
                    commandComponent.addTextEvent(new ClickEvent("run_command", clickCommand));
                    commands.addText(commandComponent);
                    commands.addNewLine();
                    color = !color;
                }
                commands.removeLast();
                ColorTheme.sendInfoTranslation(player, "tport.command.help.command.succeeded", command, commands);
                return;
            }
            LinkedHashMap<String, SubCommand> commandMap = template.collectActions();
            String searchedCommand = "/" + StringUtils.join((Object[])args, (String)" ", (int)1, (int)args.length);
            Message commands = new Message();
            boolean color = true;
            for (String tmpCommand : ((HashMap)commandMap).keySet()) {
                if (!HelpCommand.commandMatches(tmpCommand, searchedCommand, "/" + template.getName(), false)) continue;
                SubCommand subCommand = (SubCommand)((HashMap)commandMap).get(tmpCommand);
                TextComponent commandComponent = this.commandToComponent(tmpCommand, subCommand, player, color);
                commands.addText(commandComponent);
                commands.addNewLine();
                color = !color;
            }
            commands.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.help.command.succeeded", searchedCommand, commands);
        });
        commandHelp.setTabRunnable((args, player) -> {
            String s = StringUtils.join((Object[])args, (String)" ", (int)1, (int)(args.length - 1)) + " ";
            return template.collectActions().keySet().stream().map(c -> c.substring(1).toLowerCase()).filter(c -> c.startsWith(s.toLowerCase())).map(c -> c.replaceFirst("(?i)" + s, "")).collect(Collectors.toList());
        });
        commandHelp.setLooped(true);
        final Message finalCommandMessage = commandMessage;
        this.addAction(new EmptyCommand(this){
            final /* synthetic */ HelpCommand this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getCommandName() {
                return "";
            }

            @Override
            public Message getCommandDescription() {
                return finalCommandMessage;
            }

            @Override
            public String getName(String argument) {
                return "";
            }
        });
        this.addAction(commandPage);
        this.addAction(commandHelp);
    }

    public static boolean commandMatches(String command, String searchedCommand, String mainCommandName, boolean exact) {
        if (searchedCommand.length() != mainCommandName.length() && command.equalsIgnoreCase(mainCommandName)) {
            return false;
        }
        ArrayList<String> commandSplit = new ArrayList<String>();
        for (String s : command.split(" ")) {
            if (s.contains("<") || s.contains("[")) {
                commandSplit.add(null);
                continue;
            }
            if (s.contains(">") || s.contains("]")) continue;
            commandSplit.add(s);
        }
        ArrayList<String> searchedSplit = new ArrayList<String>();
        for (String s : searchedCommand.split(" ")) {
            if (s.contains("<") || s.contains("[")) {
                searchedSplit.add(null);
                continue;
            }
            if (s.contains(">") || s.contains("]")) continue;
            searchedSplit.add(s);
        }
        int forSize = Math.max(commandSplit.size(), searchedSplit.size());
        for (int i = 0; i < forSize; ++i) {
            if (i >= searchedSplit.size()) {
                return !exact;
            }
            if (i >= commandSplit.size()) {
                return !exact;
            }
            String commandArgument = (String)commandSplit.get(i);
            String searchArgument = (String)searchedSplit.get(i);
            if (exact) {
                if (searchArgument == null && commandArgument != null) {
                    return false;
                }
                if (commandArgument == null || searchArgument.equalsIgnoreCase(commandArgument) || commandArgument.contains(searchArgument)) continue;
                return false;
            }
            if (commandArgument == null || searchArgument == null || searchArgument.equalsIgnoreCase(commandArgument) || commandArgument.contains(searchArgument)) continue;
            return false;
        }
        return true;
    }

    private TextComponent commandToComponent(String command, SubCommand subCommand, Player player, boolean color) {
        TextComponent textComponent = new TextComponent(command);
        textComponent.setColor(color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color);
        Message hover = new Message();
        hover.addMessage(subCommand.getCommandDescription());
        if (Features.Feature.Permissions.isEnabled() && !subCommand.getPermissions().isEmpty()) {
            hover.addNewLine();
            hover.addNewLine();
            hover.addMessage(subCommand.permissionsHover());
            hover.addNewLine();
            if (subCommand.getPermissions().stream().anyMatch(p -> p.contains("<") || p.contains("["))) {
                hover.addMessage(ColorTheme.formatErrorTranslation("tport.command.help.page.cantMeasurePerm", new Object[0]));
            } else {
                hover.addMessage(ColorTheme.formatInfoTranslation("tport.command.help.page.perm", subCommand.hasPermissionToRun(player, false) ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.goodColor, "tport.command.help.page.do", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.badColor, "tport.command.help.page.dont", new Object[0])));
            }
        }
        textComponent.addTextEvent(new HoverEvent(hover)).setInsertion(command);
        return textComponent;
    }

    public void addExtraHelp(String helpName, Message message) {
        this.addExtraHelp(helpName, (String[] args, Player player) -> message.sendMessage(player));
    }

    public void addExtraTranslatedHelp(String helpName, Message message) {
        this.addExtraHelp(helpName, (String[] args, Player player) -> message.sendAndTranslateMessage(player));
    }

    public void addExtraHelp(final String helpName, RunRunnable command) {
        EmptyCommand helpCommand = new EmptyCommand(this){
            final /* synthetic */ HelpCommand this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String getName(String argument) {
                return helpName;
            }
        };
        helpCommand.setRunnable(command);
        helpCommand.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.help.extraHelp", new Object[0]));
        this.addExtraHelp(helpName, helpCommand);
    }

    public void addExtraHelp(String helpName, EmptyCommand helpCommand) {
        this.extraHelp.add(helpName);
        helpCommand.setCommandName(helpName, ArgumentType.FIXED);
        this.addAction(helpCommand);
    }

    public boolean removeExtraHelp(String dataName) {
        this.extraHelp.remove(dataName);
        return this.removeAction(dataName) != null;
    }

    @Override
    public String getName(String arg) {
        return "help";
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = Math.max(1, listSize);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.template.getName());
        list.addAll(this.extraHelp);
        int commandSize = this.template.collectActions().size();
        IntStream.range(0, commandSize / this.listSize).mapToObj(i -> String.valueOf(i + 1)).forEach(list::add);
        if (commandSize % this.listSize != 0) {
            list.add(String.valueOf(commandSize / this.listSize + 1));
        }
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 1) {
            if (this.commandMessage != null) {
                this.commandMessage.sendAndTranslateMessage(player);
                return;
            }
        } else if (CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            TPortAdvancement.Advancement_ImHelping.grant(player);
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/" + this.template.getName() + " help " + (this.commandMessage == null ? "<" : "[") + "page|" + this.template.getName() + " command..." + this.extraHelp.stream().collect(Collectors.joining("|", this.extraHelp.isEmpty() ? "" : "|", "")) + (this.commandMessage == null ? ">" : "]"));
    }
}

