/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commandHandler;

import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandTemplate
extends Command
implements CommandExecutor,
TabCompleter {
    protected ArrayList<SubCommand> actions = new ArrayList();
    private Message commandDescription = null;
    private String fallbackPrefix = "";
    private final JavaPlugin plugin;

    public CommandTemplate(JavaPlugin plugin, boolean register, CommandDescription description) {
        super(description.name);
        this.plugin = plugin;
        this.setDescription(description);
        if (register) {
            CommandTemplate.register(this);
        }
        this.registerActions();
    }

    public void register() {
        CommandTemplate.register(this);
    }

    public static void register(CommandTemplate template) {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.register(template.fallbackPrefix, (Command)template);
        }
        catch (Exception e) {
            template.plugin.getLogger().log(Level.WARNING, "An error occurred while registering the command '/" + template.getName() + "'");
        }
    }

    public static List<String> filterContaining(String arg, Collection<String> fullList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ss : fullList) {
            if (ss == null || arg == null || !ss.toLowerCase().contains(arg.toLowerCase())) continue;
            list.add(ss);
        }
        return list;
    }

    private static List<String> tabList(List<SubCommand> actions, String[] args, Player player, int i) {
        if (args.length == 1) {
            ArrayList<String> tabList = new ArrayList<String>();
            for (SubCommand subCommand : actions) {
                tabList.add(subCommand.getName(args[0]));
            }
            return CommandTemplate.filterContaining(args[0], tabList);
        }
        if (args.length == i) {
            ArrayList<String> tabList = new ArrayList<String>();
            for (SubCommand subCommand : actions) {
                if (!subCommand.getName(args[i - 2]).equalsIgnoreCase(args[i - 2])) continue;
                tabList.addAll(CommandTemplate.filterContaining(args[i - 1], subCommand.tabList(player, args)));
            }
            return tabList;
        }
        try {
            for (SubCommand subCommand : actions) {
                if (!subCommand.getName(args[i - 2]).equalsIgnoreCase(args[i - 2])) continue;
                if (subCommand instanceof EmptyCommand && ((EmptyCommand)subCommand).isLooped()) {
                    return CommandTemplate.filterContaining(args[args.length - 1], subCommand.tabList(player, args));
                }
                return CommandTemplate.tabList(subCommand.getActions(), args, player, i + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CommandTemplate.tabList(actions, args, player, i + 1);
    }

    public static boolean runCommands(List<SubCommand> actions, String arg, String[] args, Player player) {
        for (SubCommand action : actions) {
            if (!action.getName(arg).equalsIgnoreCase(arg) && !action.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(arg))) continue;
            action.run(args, player);
            return true;
        }
        return false;
    }

    public static String convertToArgs(List<SubCommand> commands, boolean optional) {
        return (optional ? "[" : "<") + commands.stream().map(SubCommand::getCommandName).filter(StringUtils::isNotEmpty).collect(Collectors.joining("|")) + (optional ? "]" : ">");
    }

    private void setDescription(CommandDescription description) {
        if (description.getFallbackPrefix().equalsIgnoreCase("")) {
            description.setFallbackPrefix(this.plugin.getName());
        }
        this.setName(description.getName());
        this.setUsage(description.getUsage());
        if (description.getName() != null) {
            this.setLabel(description.getName());
        }
        if (description.getDescription() != null) {
            this.setDescription(description.getDescription());
        }
        if (description.getFallbackPrefix() != null) {
            this.fallbackPrefix = description.getFallbackPrefix();
        }
    }

    public void registerActions() {
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    private void collectActions(SubCommand actions, Pair<String, SubCommand> pre, boolean b, LinkedHashMap<String, SubCommand> commandList) {
        for (SubCommand action : actions.getActions()) {
            Object name = "";
            String suffix = "";
            if (action.isLinked()) {
                if (!b) {
                    name = "[";
                    b = true;
                    commandList.put(pre.getLeft().trim(), pre.getRight());
                } else if (action.getActions().isEmpty() || !action.getActions().get(0).isLinked()) {
                    suffix = "]";
                    b = false;
                }
            }
            switch (action.getArgumentType()) {
                case REQUIRED: {
                    name = (String)name + "<" + action.getCommandName() + (!action.getCommandName().isEmpty() && action instanceof EmptyCommand && ((EmptyCommand)action).isLooped() ? "..." : "") + ">";
                    break;
                }
                case OPTIONAL: {
                    commandList.put(pre.getLeft().trim(), pre.getRight());
                    if (pre.getRight() == null) {
                        name = (String)name + "[" + action.getCommandName() + (!action.getCommandName().isEmpty() && action instanceof EmptyCommand && ((EmptyCommand)action).isLooped() ? "..." : "") + "]";
                        break;
                    }
                    name = (String)name + "<" + action.getCommandName() + (!action.getCommandName().isEmpty() && action instanceof EmptyCommand && ((EmptyCommand)action).isLooped() ? "..." : "") + ">";
                    break;
                }
                default: {
                    name = (String)name + action.getCommandName() + (!action.getCommandName().isEmpty() && action instanceof EmptyCommand && ((EmptyCommand)action).isLooped() ? "..." : "");
                }
            }
            name = (String)name + suffix;
            if (action instanceof EmptyCommand && ((EmptyCommand)action).isLooped()) {
                if (action.isLinked()) {
                    name = (String)name + "]";
                }
                commandList.put((pre.getLeft() + " " + (String)name).trim(), action);
                continue;
            }
            if (action.getActions().isEmpty()) {
                commandList.put((pre.getLeft() + " " + (String)name).trim(), action);
                continue;
            }
            this.collectActions(action, new Pair<CallSite, SubCommand>((CallSite)((Object)(pre.getLeft() + " " + (String)name)), action), b, commandList);
        }
    }

    public LinkedHashMap<String, SubCommand> collectActions() {
        LinkedHashMap<String, SubCommand> commandList = new LinkedHashMap<String, SubCommand>();
        for (SubCommand action : this.getActions()) {
            if (action instanceof EmptyCommand && ((EmptyCommand)action).isLooped()) continue;
            if (action.getActions().isEmpty()) {
                commandList.put(("/" + this.getName() + " " + action.getCommandName()).trim(), action);
                continue;
            }
            this.collectActions(action, new Pair<CallSite, SubCommand>((CallSite)((Object)("/" + this.getName() + " " + action.getCommandName())), action), false, commandList);
        }
        return commandList;
    }

    public abstract boolean execute(@Nonnull CommandSender var1, @Nonnull String var2, @Nonnull String[] var3);

    public final boolean onCommand(@Nonnull CommandSender commandSender, @Nonnull Command command, @Nonnull String alias, @Nonnull String[] args) {
        return this.execute(commandSender, alias, args);
    }

    @Nonnull
    public List<String> tabComplete(@Nonnull CommandSender sender, @Nonnull String alias, @Nonnull String[] args, Location location) throws IllegalArgumentException {
        if (sender instanceof Player) {
            return this.tabList(args, (Player)sender);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<String> tabComplete(@Nonnull CommandSender sender, @Nonnull String alias, @Nonnull String[] args) throws IllegalArgumentException {
        return this.tabComplete(sender, alias, args, null);
    }

    public final List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, @Nonnull String[] args) {
        return this.tabComplete(sender, alias, args, null);
    }

    public List<String> tabList(String[] args, Player player) {
        return CommandTemplate.tabList(this.actions, args, player, 1);
    }

    public void addAction(SubCommand subCommand) {
        this.actions.add(subCommand);
    }

    public boolean removeAction(SubCommand subCommand) {
        return this.actions.remove(subCommand);
    }

    public SubCommand removeAction(String actionName) {
        for (SubCommand sub : this.actions) {
            if (!sub.getName(actionName).equals(actionName) || !this.actions.remove(sub)) continue;
            return sub;
        }
        return null;
    }

    public SubCommand getAction(String action) {
        return this.getAction(action, null);
    }

    public SubCommand getAction(String action, SubCommand def) {
        for (SubCommand subCommand : this.getActions()) {
            if (!subCommand.getName(action).equalsIgnoreCase(action)) continue;
            return subCommand;
        }
        return def;
    }

    public ArrayList<SubCommand> getActions() {
        return this.actions;
    }

    public Message getCommandDescription() {
        return this.commandDescription;
    }

    public void setCommandDescription(Message commandDescription) {
        this.commandDescription = commandDescription;
    }

    public void setCommandDescription(TextComponent ... textComponents) {
        this.setCommandDescription(new Message(textComponents));
    }

    protected boolean runCommands(String arg, String[] args, Player player) {
        return CommandTemplate.runCommands(this.actions, arg, args, player);
    }

    public String getFallbackPrefix() {
        return this.fallbackPrefix;
    }

    public static class CommandDescription {
        private String name;
        private String fallbackPrefix;
        private String description;
        private String usage;
        private List<String> aliases;

        public CommandDescription(@Nonnull String name, String pluginName) {
            this(name, pluginName, "No description given", "/" + name);
        }

        public CommandDescription(@Nonnull String name, String pluginName, String description, String usage) {
            this(name, pluginName, description, usage, new ArrayList<String>());
        }

        public CommandDescription(@Nonnull String name, String pluginName, String description, String usage, List<String> aliases) {
            this.name = name;
            this.fallbackPrefix = pluginName;
            this.description = description;
            this.usage = usage;
            this.aliases = aliases;
        }

        public String getName() {
            return this.name;
        }

        public void setName(@Nonnull String name) {
            this.name = name;
        }

        public String getFallbackPrefix() {
            return this.fallbackPrefix;
        }

        public void setFallbackPrefix(String fallbackPrefix) {
            this.fallbackPrefix = fallbackPrefix;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUsage() {
            return this.usage;
        }

        public void setUsage(String usage) {
            this.usage = usage;
        }

        public boolean addAlias(String alias) {
            return this.aliases.add(alias);
        }

        public boolean removeAlias(String alias) {
            return this.aliases.remove(alias);
        }
    }
}

