/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class V1_21_6_FeatureTPAdapter
extends TPortAdapter {
    private IRegistry<Structure> getStructureRegistry(WorldServer worldServer) {
        return worldServer.K_().f(Registries.bj);
    }

    @Override
    public Pair<Location, String> searchFeature(Player player, Location startLocation, List<String> features) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList<Holder<Structure>> featureList = new ArrayList<Holder<Structure>>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(player.getWorld());
        IRegistry<Structure> structureRegistry = this.getStructureRegistry(worldServer);
        for (String feature : features) {
            Structure structure = (Structure)structureRegistry.a(MinecraftKey.b((String)feature));
            Optional optional = structureRegistry.d((Object)structure);
            if (!optional.isPresent()) continue;
            Holder holder = structureRegistry.e((Object)structure);
            featureList.add((Holder<Structure>)holder);
        }
        return this.featureFinder(player, startLocation, featureList);
    }

    private double distToLowCornerSqr(BlockPosition b1, BlockPosition b2) {
        double deltaX = b1.u() - b2.u();
        double deltaY = b1.v() - b2.v();
        double deltaZ = b1.w() - b2.w();
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private Pair<Location, String> featureFinder(@Nullable Player player, Location startLocation, List<Holder<Structure>> featureList) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        BlockPosition startPosition = new BlockPosition(startLocation.getBlockX(), startLocation.getBlockY(), startLocation.getBlockZ());
        WorldServer worldServer = (WorldServer)this.getWorldServer(startLocation.getWorld());
        IRegistry<Structure> structureRegistry = this.getStructureRegistry(worldServer);
        Set generateInBiomesList = featureList.stream().flatMap(holder -> ((Structure)holder.a()).a().a()).collect(Collectors.toSet());
        if (generateInBiomesList.isEmpty()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGenerating", new Object[0]);
            return null;
        }
        ChunkGenerator chunkGenerator = worldServer.n().g();
        WorldChunkManager worldChunkManager = chunkGenerator.d();
        Set generatedBiomes = worldChunkManager.c();
        if (Collections.disjoint(generatedBiomes, generateInBiomesList)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGeneratingInWorld", new Object[0]);
            return null;
        }
        Object2ObjectArrayMap placementMap = new Object2ObjectArrayMap();
        ChunkGeneratorStructureState chunkGeneratorStructureState = worldServer.n().h();
        for (Holder<Structure> structureHolder : featureList) {
            HolderSet generateInBiomes = ((Structure)structureHolder.a()).a();
            if (!generatedBiomes.stream().anyMatch(arg_0 -> ((HolderSet)generateInBiomes).a(arg_0))) continue;
            List structurePlacements = chunkGeneratorStructureState.a(structureHolder);
            for (StructurePlacement structurePlacement : structurePlacements) {
                placementMap.computeIfAbsent(structurePlacement, unusedStructurePlacement -> new ObjectArraySet()).add(structureHolder);
            }
        }
        ArrayList placementList = new ArrayList(placementMap.size());
        double closestDistance = Double.MAX_VALUE;
        Pair<BlockPosition, Holder<Structure>> closestPair = null;
        for (Map.Entry entry : placementMap.entrySet()) {
            StructurePlacement structureplacement = (StructurePlacement)entry.getKey();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockPos;
                double distance;
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)structureplacement;
                Pair<BlockPosition, Holder<Structure>> pairCandidate = this.getNearestGeneratedStructure(chunkGenerator, (Set)entry.getValue(), worldServer, startPosition, concentricRingsStructurePlacement);
                if (pairCandidate == null || !((distance = this.distToLowCornerSqr(startPosition, blockPos = pairCandidate.getLeft())) < closestDistance)) continue;
                closestDistance = distance;
                closestPair = pairCandidate;
                continue;
            }
            if (!(structureplacement instanceof RandomSpreadStructurePlacement)) continue;
            placementList.add(entry);
        }
        if (!placementList.isEmpty()) {
            int sectionX = startLocation.getBlockX() >> 4;
            int sectionZ = startLocation.getBlockZ() >> 4;
            long worldSeed = chunkGeneratorStructureState.d();
            for (int squareSize = 0; squareSize <= 100; ++squareSize) {
                boolean foundThisRound = false;
                for (Map.Entry entry : placementList) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> pairCandidate = this.getNearestGeneratedStructure(chunkGenerator, (Set)entry.getValue(), worldServer, sectionX, sectionZ, squareSize, worldSeed, randomspreadstructureplacement);
                    if (pairCandidate == null) continue;
                    foundThisRound = true;
                    BlockPosition blockPos = pairCandidate.getLeft();
                    double distance = this.distToLowCornerSqr(startPosition, blockPos);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPair = pairCandidate;
                }
                if (!foundThisRound) continue;
                if (closestPair == null) {
                    return null;
                }
                BlockPosition blockPos = (BlockPosition)closestPair.getLeft();
                return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)blockPos.u(), 200.0, (double)blockPos.w()), structureRegistry.b((Object)((Structure)closestPair.getRight().a())).a());
            }
        }
        if (closestPair == null) {
            return null;
        }
        BlockPosition blockPos = (BlockPosition)closestPair.getLeft();
        return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)blockPos.u(), 200.0, (double)blockPos.w()), structureRegistry.b((Object)((Structure)((Holder)closestPair.getRight()).a())).a());
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(ChunkGenerator chunkGenerator, Set<Holder<Structure>> structureSet, WorldServer worldServer, BlockPosition startPosition, ConcentricRingsStructurePlacement concentricRingsStructurePlacement) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method m = ChunkGenerator.class.getDeclaredMethod("a", Set.class, WorldServer.class, StructureManager.class, BlockPosition.class, Boolean.TYPE, ConcentricRingsStructurePlacement.class);
        m.setAccessible(true);
        com.mojang.datafixers.util.Pair p = (com.mojang.datafixers.util.Pair)m.invoke((Object)chunkGenerator, structureSet, worldServer, worldServer.b(), startPosition, false, concentricRingsStructurePlacement);
        if (p == null) {
            return null;
        }
        return new Pair<BlockPosition, Holder<Structure>>((BlockPosition)p.getFirst(), (Holder)p.getSecond());
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(ChunkGenerator chunkGenerator, Set<Holder<Structure>> structureSet, WorldServer worldServer, int sectionX, int sectionZ, int squareSize, long seed, RandomSpreadStructurePlacement randomSpreadStructurePlacement) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method m = ChunkGenerator.class.getDeclaredMethod("a", Set.class, IWorldReader.class, StructureManager.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, RandomSpreadStructurePlacement.class);
        m.setAccessible(true);
        com.mojang.datafixers.util.Pair p = (com.mojang.datafixers.util.Pair)m.invoke((Object)chunkGenerator, structureSet, worldServer, worldServer.b(), sectionX, sectionZ, squareSize, false, seed, randomSpreadStructurePlacement);
        if (p == null) {
            return null;
        }
        return new Pair<BlockPosition, Holder<Structure>>((BlockPosition)p.getFirst(), (Holder)p.getSecond());
    }

    @Override
    public List<String> availableFeatures() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        World world = (World)Bukkit.getWorlds().get(0);
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = this.getStructureRegistry(worldServer);
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftKey minecraftKey : structureRegistry.i()) {
            String lowerCase = minecraftKey.a().toLowerCase();
            list.add(lowerCase);
        }
        return list;
    }

    @Override
    public List<String> availableFeatures(World world) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ArrayList<String> returnList = new ArrayList<String>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = this.getStructureRegistry(worldServer);
        ChunkGenerator chunkGenerator = worldServer.n().g();
        WorldChunkManager worldChunkManager = chunkGenerator.d();
        Set generatedBiomes = worldChunkManager.c();
        for (MinecraftKey minecraftKey : structureRegistry.i()) {
            Structure structure = (Structure)structureRegistry.a(minecraftKey);
            HashSet generateInBiomesList = new HashSet();
            HolderSet biomes = structure.a();
            Stream biomeStream = biomes.a();
            biomeStream.forEach(generateInBiomesList::add);
            if (generateInBiomesList.isEmpty() || Collections.disjoint(generatedBiomes, generateInBiomesList)) continue;
            returnList.add(minecraftKey.a());
        }
        return returnList;
    }

    @Override
    public List<Pair<String, List<String>>> getFeatureTags(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList<Pair<String, List<String>>> list = new ArrayList<Pair<String, List<String>>>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = this.getStructureRegistry(worldServer);
        structureRegistry.l().forEach(named -> {
            Stream values = named.a();
            List<String> features = values.map(holder -> (Structure)holder.a()).map(arg_0 -> ((IRegistry)structureRegistry).b(arg_0)).filter(Objects::nonNull).map(key -> key.a().toLowerCase()).toList();
            String tagKeyName = named.h().b().a().toLowerCase();
            list.add(new Pair<CallSite, List<String>>((CallSite)((Object)("#" + tagKeyName)), features));
        });
        return list;
    }
}

