/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.adapters.V1_21_10_BiomeTPAdapter;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.keyboard.QuickType;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class V1_21_10_FancyMessageAdapter
extends V1_21_10_BiomeTPAdapter {
    BlockPosition newBlockPosition(Location l) {
        return new BlockPosition(l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    @Override
    public int JSONVersion() {
        return 1;
    }

    @Override
    public void setDisplayName(ItemStack itemStack, @Nonnull Message title, ColorTheme theme) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        ItemMeta im = itemStack.getItemMeta();
        String version = ReflectionManager.getServerClassesVersion();
        Field displayNameField = Class.forName("org.bukkit.craftbukkit." + version + "inventory.CraftMetaItem").getDeclaredField("displayName");
        displayNameField.setAccessible(true);
        displayNameField.set(im, CraftChatMessage.fromJSON((String)title.translateJSON(theme)));
        itemStack.setItemMeta(im);
    }

    @Override
    public void setLore(ItemStack itemStack, @Nonnull Collection<Message> lore, ColorTheme theme) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ItemMeta im = itemStack.getItemMeta();
        String version = ReflectionManager.getServerClassesVersion();
        Field loreField = Class.forName("org.bukkit.craftbukkit." + version + "inventory.CraftMetaItem").getDeclaredField("lore");
        loreField.setAccessible(true);
        List l = lore.stream().filter(Objects::nonNull).map(line -> CraftChatMessage.fromJSON((String)line.translateJSON(theme))).collect(Collectors.toList());
        loreField.set(im, l);
        itemStack.setItemMeta(im);
    }

    @Override
    public void sendMessage(Player player, String message) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        IChatBaseComponent chatComponent = CraftChatMessage.fromJSON((String)message);
        ClientboundSystemChatPacket packet = new ClientboundSystemChatPacket(chatComponent, false);
        this.sendPlayerPacket(player, packet);
    }

    @Override
    public void sendTitle(Player player, String message, Message.TitleTypes titleType, int fadeIn, int displayTime, int fadeOut) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        IChatBaseComponent text = CraftChatMessage.fromJSON((String)message);
        Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game." + titleType.getMCClass());
        Class<?> chatComponent = Class.forName("net.minecraft.network.chat.IChatBaseComponent");
        Packet packetObject = (Packet)packetClass.getConstructor(chatComponent).newInstance(text);
        if (fadeIn != -1 || displayTime != -1 || fadeOut != -1) {
            ClientboundSetTitlesAnimationPacket clientboundSetTitlesAnimationPacket = new ClientboundSetTitlesAnimationPacket(fadeIn, displayTime, fadeOut);
            this.sendPlayerPacket(player, clientboundSetTitlesAnimationPacket);
        }
        this.sendPlayerPacket(player, packetObject);
    }

    @Override
    public void sendInventory(Player player, String stringTitle, Inventory inventory) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        IChatBaseComponent chatComponent = CraftChatMessage.fromJSON((String)stringTitle);
        EntityPlayer entityPlayer = (EntityPlayer)this.getEntityPlayer(player);
        CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        this.sendPlayerPacket(player, new PacketPlayOutOpenWindow(container.l, windowType, chatComponent));
        entityPlayer.cl = container;
        entityPlayer.a((Container)container);
    }

    @Override
    public void sendSignEditor(Player player, Location loc) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.sendPlayerPacket(player, new PacketPlayOutOpenSignEditor(this.newBlockPosition(loc), false));
    }

    @Override
    public void setQuickTypeSignHandler(Player player) throws IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        ChannelDuplexHandler channelDuplexHandler = V1_21_10_FancyMessageAdapter.getChannelDuplexHandler(player);
        PlayerConnection playerConnection = (PlayerConnection)this.getPlayerConnection(player);
        NetworkManager networkManager = ReflectionManager.getPrivateField(NetworkManager.class, playerConnection, ServerCommonPacketListenerImpl.class);
        Channel channel = networkManager.n;
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.context("fancyMessage_quickType") != null) {
            this.removeQuickTypeSignHandler(player);
        }
        pipeline.addBefore("packet_handler", "fancyMessage_quickType", (ChannelHandler)channelDuplexHandler);
    }

    @Nonnull
    private static ChannelDuplexHandler getChannelDuplexHandler(Player player) {
        final UUID uuid = player.getUniqueId();
        return new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
                PacketPlayInUpdateSign inUpdateSign;
                String[] lines;
                if (packet instanceof PacketPlayInUpdateSign && QuickType.onSignEdit(lines = (inUpdateSign = (PacketPlayInUpdateSign)packet).f(), uuid)) {
                    return;
                }
                super.channelRead(ctx, packet);
            }
        };
    }

    @Override
    public void removeQuickTypeSignHandler(Player player) throws IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        PlayerConnection playerConnection = (PlayerConnection)this.getPlayerConnection(player);
        NetworkManager networkManager = ReflectionManager.getPrivateField(NetworkManager.class, playerConnection, ServerCommonPacketListenerImpl.class);
        Channel channel = networkManager.n;
        channel.eventLoop().submit(() -> channel.pipeline().remove("fancyMessage_quickType"));
    }

    @Override
    public void sendBlockChange(Player player, Location blockLoc, Block block) {
        player.sendBlockChange(blockLoc, block.getBlockData());
    }

    @Override
    public void sendBlockChange(Player player, Location blockLoc, Material material) {
        player.sendBlockChange(blockLoc, material.createBlockData());
    }
}

