/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;

public class ReflectionManager {
    public static String getServerClassesVersion() {
        String pack = Bukkit.getServer().getClass().getPackage().getName();
        if (pack.length() == 22) {
            return "";
        }
        return pack.replace(".", ",").split(",")[3] + ".";
    }

    public static String getServerVersion() {
        String s = Bukkit.getVersion();
        int startIndex = s.indexOf(":");
        return s.substring(startIndex + 2, s.length() - 1);
    }

    public static <R, I> R getPrivateField(Class<R> r, I invoked) throws IllegalAccessException {
        if (invoked == null) {
            return null;
        }
        for (Field f : invoked.getClass().getDeclaredFields()) {
            if (!f.getType().equals(r)) continue;
            f.setAccessible(true);
            return (R)f.get(invoked);
        }
        return null;
    }

    public static <R, I> R getPrivateField(Class<R> r, I invoked, Class<?> c) throws IllegalAccessException {
        if (invoked == null) {
            return null;
        }
        for (Field f : c.getDeclaredFields()) {
            if (!f.getType().equals(r)) continue;
            f.setAccessible(true);
            return (R)f.get(invoked);
        }
        return null;
    }

    public static <R, I> R getField(Class<R> r, I invoked) throws IllegalAccessException {
        if (invoked == null) {
            return null;
        }
        for (Field f : invoked.getClass().getFields()) {
            if (!f.getType().equals(r)) continue;
            return (R)f.get(invoked);
        }
        return null;
    }

    public static <R, I> R get(Class<R> r, I invoked) throws InvocationTargetException, IllegalAccessException {
        if (invoked == null) {
            return null;
        }
        for (Method m : invoked.getClass().getMethods()) {
            if (!m.getReturnType().equals(r) || m.getParameterCount() != 0) continue;
            return (R)m.invoke(invoked, new Object[0]);
        }
        return null;
    }

    public static <R, I, P> R get(Class<R> returnClass, I invoked, P parameter) throws InvocationTargetException, IllegalAccessException {
        for (Method m : invoked.getClass().getMethods()) {
            Class<?>[] parameterTypes;
            if (!m.getReturnType().equals(returnClass) || (parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].equals(parameter.getClass())) continue;
            return (R)m.invoke(invoked, parameter);
        }
        return null;
    }

    public static <R, I, P> R get(Class<R> returnClass, I invoked, P parameter, Class<?> parameterClass) throws InvocationTargetException, IllegalAccessException {
        for (Method m : invoked.getClass().getMethods()) {
            Class<?>[] parameterTypes;
            if (!m.getReturnType().equals(returnClass) || (parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].equals(parameterClass)) continue;
            return (R)m.invoke(invoked, parameter);
        }
        return null;
    }

    public static <R, I> R get(Class<R> r, I invoked, @Nullable Annotation annotation) throws InvocationTargetException, IllegalAccessException {
        if (invoked == null) {
            return null;
        }
        for (Method m : invoked.getClass().getMethods()) {
            if (!m.getReturnType().equals(r) || (annotation != null ? !m.getAnnotations()[0].equals(annotation) : m.getAnnotations().length != 0) || m.getParameterCount() != 0) continue;
            return (R)m.invoke(invoked, new Object[0]);
        }
        return null;
    }
}

