/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport;

import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.Adapter;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Redirect;
import com.spaceman.tport.commands.tport.Reload;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.commands.tport.Version;
import com.spaceman.tport.commands.tport.backup.Auto;
import com.spaceman.tport.commands.tport.resourcePack.ResolutionCommand;
import com.spaceman.tport.events.CommandEvent;
import com.spaceman.tport.events.JoinEvent;
import com.spaceman.tport.events.PreviewEvents;
import com.spaceman.tport.events.RespawnEvent;
import com.spaceman.tport.events.TeleporterEvents;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.inventories.keyboard.QuickType;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.history.HistoryEvents;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.metrics.BiomeSearchCounter;
import com.spaceman.tport.metrics.CommandCounter;
import com.spaceman.tport.metrics.FeatureSearchCounter;
import com.spaceman.tport.metrics.Metrics;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRestriction;
import com.spaceman.tport.tpEvents.animations.ExplosionAnimation;
import com.spaceman.tport.tpEvents.animations.SimpleAnimation;
import com.spaceman.tport.tpEvents.restrictions.DoSneakRestriction;
import com.spaceman.tport.tpEvents.restrictions.InteractRestriction;
import com.spaceman.tport.tpEvents.restrictions.NoneRestriction;
import com.spaceman.tport.tpEvents.restrictions.WalkRestriction;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.waypoint.WaypointManager;
import com.spaceman.tport.webMaps.BlueMapHandler;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public TPortAdapter adapter = null;
    public static final String discordLink = "https://discord.gg/tq5RTmSbHU";
    public static String[] supportedVersions = new String[0];

    public static <O> O getOrDefault(@Nullable O object, O def) {
        return object == null ? def : object;
    }

    public static Object getOrDefaults(Object ... objects) {
        for (Object o : objects) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public static Main getInstance() {
        return (Main)JavaPlugin.getPlugin(Main.class);
    }

    public static ArrayList<ItemStack> giveItems(Player player, List<ItemStack> items) {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().addItem(items.toArray(new ItemStack[0])).values()) {
            player.getWorld().dropItem(player.getLocation(), item);
            returnList.add(item);
            ColorTheme.sendErrorTranslation(player, "tport.main.dropItem", item.getType().name());
        }
        return returnList;
    }

    public static ArrayList<ItemStack> giveItems(Player player, ItemStack ... items) {
        return Main.giveItems(player, Arrays.asList(items));
    }

    @SafeVarargs
    public static <I, J> HashMap<I, J> asMap(Pair<I, J> ... pairs) {
        HashMap<I, J> map = new HashMap<I, J>();
        for (Pair<I, J> pair : pairs) {
            if (pair == null) continue;
            map.put(pair.getLeft(), pair.getRight());
        }
        return map;
    }

    public static boolean containsSpecialCharacter(String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        Pattern p = Pattern.compile("[^A-Za-z0-9_-]");
        Matcher m = p.matcher(s);
        return m.find();
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }

    public static Rectangle getSearchArea(Player player) {
        World world = player.getWorld();
        Location center = world.getWorldBorder().getCenter();
        int size = (int)world.getWorldBorder().getSize();
        int halfSize = size / 2;
        return new Rectangle(center.getBlockX() - halfSize, center.getBlockZ() - halfSize, size, size);
    }

    public static Location getRandomLocation(Player player) {
        Random random = new Random();
        Rectangle searchArea = Main.getSearchArea(player);
        return new Location(player.getWorld(), (double)(random.nextInt(searchArea.width) + searchArea.x), 0.0, (double)(random.nextInt(searchArea.height) + searchArea.y));
    }

    public static Location getClosestLocation(Player player) {
        Rectangle searchArea = Main.getSearchArea(player);
        if (searchArea.contains(player.getLocation().getX(), player.getLocation().getZ())) {
            return player.getLocation();
        }
        int currentX = player.getLocation().getBlockX();
        int currentZ = player.getLocation().getBlockZ();
        int newX = Math.min(Math.max(currentX, searchArea.x), searchArea.x + searchArea.width);
        int newZ = Math.min(Math.max(currentZ, searchArea.y), searchArea.y + searchArea.height);
        return new Location(player.getLocation().getWorld(), (double)newX, player.getLocation().getY(), (double)newZ);
    }

    public static Boolean toBoolean(String arg) {
        return Main.toBoolean(arg, null);
    }

    public static Boolean toBoolean(String arg, @Nullable Boolean def) {
        boolean t = Main.isTrue(arg);
        boolean f = Main.isFalse(arg);
        return !t && !f ? def : Boolean.valueOf(t);
    }

    public static boolean isTrue(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.toLowerCase()).equals("true") || arg.equals("yes") || arg.equals("y") || arg.equals("enable");
    }

    public static boolean isFalse(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.toLowerCase()).equals("false") || arg.equals("no") || arg.equals("n") || arg.equals("disable");
    }

    private void setSupportedVersions() {
        InputStream is = this.getClassLoader().getResourceAsStream("plugin.yml");
        if (is == null) {
            this.getLogger().log(Level.INFO, "Could not update the supported versions list");
            return;
        }
        InputStreamReader r = new InputStreamReader(is);
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((Reader)r);
        supportedVersions = yaml.getStringList("supportedVersions").toArray(new String[0]);
    }

    public void onEnable() {
        this.getLogger().log(Level.INFO, "TPort has a Discord server, for any questions/more go to: https://discord.gg/tq5RTmSbHU");
        this.setSupportedVersions();
        Version.checkForLatestVersion();
        Adapter.registerAdapter("adaptive", "com.spaceman.tport.adapters.AdaptiveAdapter");
        Adapter.registerAdapter("1.18.2", "com.spaceman.tport.adapters.V1_18_2_Adapter");
        Adapter.registerAdapter("1.19.4", "com.spaceman.tport.adapters.V1_19_4_Adapter");
        Adapter.registerAdapter("1.20.4", "com.spaceman.tport.adapters.V1_20_4_Adapter");
        Adapter.registerAdapter("1.20.5", "com.spaceman.tport.adapters.V1_20_6_Adapter");
        Adapter.registerAdapter("1.20.6", "com.spaceman.tport.adapters.V1_20_6_Adapter");
        Adapter.registerAdapter("1.21", "com.spaceman.tport.adapters.V1_21_Adapter");
        Adapter.registerAdapter("1.21.1", "com.spaceman.tport.adapters.V1_21_Adapter");
        Adapter.registerAdapter("1.21.3", "com.spaceman.tport.adapters.V1_21_3_Adapter");
        Adapter.registerAdapter("1.21.4", "com.spaceman.tport.adapters.V1_21_4_Adapter");
        Adapter.registerAdapter("1.21.5", "com.spaceman.tport.adapters.V1_21_5_Adapter");
        Adapter.registerAdapter("1.21.6", "com.spaceman.tport.adapters.V1_21_6_Adapter");
        Adapter.registerAdapter("1.21.7", "com.spaceman.tport.adapters.V1_21_6_Adapter");
        Adapter.registerAdapter("1.21.8", "com.spaceman.tport.adapters.V1_21_6_Adapter");
        Adapter.registerAdapter("1.21.9", "com.spaceman.tport.adapters.V1_21_10_Adapter");
        Adapter.registerAdapter("1.21.10", "com.spaceman.tport.adapters.V1_21_10_Adapter");
        Adapter.registerAdapter("1.21.11", "com.spaceman.tport.adapters.V1_21_11_Adapter");
        ConfigurationSerialization.registerClass(ColorTheme.class, (String)"ColorTheme");
        ConfigurationSerialization.registerClass(TPort.class, (String)"TPort");
        ConfigurationSerialization.registerClass(Pair.class, (String)"Pair");
        ConfigurationSerialization.registerClass(MultiColor.class, (String)"MultiColor");
        ConfigurationSerialization.registerClass(TPort.LogEntry.class, (String)"LogEntry");
        ParticleAnimation.registerAnimation(SimpleAnimation::new);
        ParticleAnimation.registerAnimation(ExplosionAnimation::new);
        TPRestriction.registerRestriction(NoneRestriction::new);
        TPRestriction.registerRestriction(WalkRestriction::new);
        TPRestriction.registerRestriction(InteractRestriction::new);
        TPRestriction.registerRestriction(DoSneakRestriction::new);
        Reload.reloadTPort();
        TeleportHistory.registerPluginFilterModel((Plugin)this, TPortInventories.history_filter_plugin_tport_model);
        SafetyCheck.setSafetyCheck((feet, clearFeet) -> {
            Location head = feet.clone().add(0.0, 1.0, 0.0);
            Location ground = feet.clone().add(0.0, -1.0, 0.0);
            List<Material> damageableMaterials = Arrays.asList(Material.LAVA, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.FIRE, Material.SOUL_FIRE, Material.MAGMA_BLOCK);
            return !(damageableMaterials.contains(ground.getBlock().getType()) || damageableMaterials.contains(head.getBlock().getType()) || damageableMaterials.contains(feet.getBlock().getType()) || !ground.getBlock().getType().isSolid() && !ground.getBlock().getType().equals((Object)Material.WATER) || head.getBlock().getType().isSolid() || clearFeet && feet.getBlock().getType().isSolid());
        });
        Features.convert();
        ResolutionCommand.Resolution.registerResourcePackResolution("x16", "https://github.com/JasperBouwman/TPort/releases/download/TPort-" + Main.getInstance().getDescription().getVersion() + "/TPort_16x_dark.zip");
        ResolutionCommand.Resolution.registerResourcePackResolution("x32", "https://github.com/JasperBouwman/TPort/releases/download/TPort-" + Main.getInstance().getDescription().getVersion() + "/TPort_32x_dark.zip");
        ResolutionCommand.Resolution.registerResourcePackResolution("x16_light", "https://github.com/JasperBouwman/TPort/releases/download/TPort-" + Main.getInstance().getDescription().getVersion() + "/TPort_16x_light.zip");
        ResolutionCommand.Resolution.registerResourcePackResolution("x32_light", "https://github.com/JasperBouwman/TPort/releases/download/TPort-" + Main.getInstance().getDescription().getVersion() + "/TPort_32x_light.zip");
        ResolutionCommand.Resolution.registerResourcePackResolution("custom", null);
        TPortCommand.getInstance().register();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new TeleporterEvents(), (Plugin)this);
        pm.registerEvents((Listener)new JoinEvent(), (Plugin)this);
        pm.registerEvents((Listener)new RespawnEvent(), (Plugin)this);
        pm.registerEvents((Listener)new CommandEvent(), (Plugin)this);
        pm.registerEvents((Listener)new FancyClickEvent(), (Plugin)this);
        pm.registerEvents((Listener)new WaypointManager(), (Plugin)this);
        HistoryEvents.load();
        for (String uuid : Files.tportData.getKeys("tport")) {
            for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                WaypointManager.registerTPort(tport);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            JoinEvent.setData(player);
        }
        if (Files.tportConfig.getConfig().contains("tport.onlineState")) {
            if (Files.tportConfig.getConfig().getBoolean("tport.onlineState") != Bukkit.getOnlineMode()) {
                if (Bukkit.getOnlineMode()) {
                    this.getLogger().log(Level.WARNING, "When TPort was installed, the server was in offline mode. By changing this mode TPort will have unexpected behaviour. Players will lose their settings/TPorts");
                } else {
                    this.getLogger().log(Level.WARNING, "When TPort was installed, the server was in online mode. By changing this mode TPort will have unexpected behaviour. Players will lose their settings/TPorts");
                }
            }
        } else {
            Files.tportConfig.getConfig().set("tport.onlineState", (Object)Bukkit.getOnlineMode());
        }
        if (Features.Feature.Metrics.isEnabled()) {
            Main.getInstance().getLogger().log(Level.INFO, "Enabling metrics. Thank you for enabling metrics, powered by bStats. To view stats use '/tport metrics viewStats'");
            Metrics m = new Metrics(this, 8061);
            m.addCustomChart(new Metrics.AdvancedPie("command_usage", CommandCounter::getData));
            m.addCustomChart(new Metrics.AdvancedPie("biome_searches", BiomeSearchCounter::getData));
            m.addCustomChart(new Metrics.AdvancedPie("feature_searches", FeatureSearchCounter::getData));
            m.addCustomChart(new Metrics.SimplePie("tport_version", () -> this.getDescription().getVersion()));
            m.addCustomChart(new Metrics.AdvancedPie("features", () -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (Features.Feature feature : Features.Feature.values()) {
                    if (feature == Features.Feature.Dynmap) {
                        if (DynmapHandler.isEnabled()) {
                            map.put(feature.name(), 1);
                            continue;
                        }
                        map.put(feature.name(), 0);
                        continue;
                    }
                    if (feature == Features.Feature.BlueMap) {
                        if (BlueMapHandler.isEnabled()) {
                            map.put(feature.name(), 1);
                            continue;
                        }
                        map.put(feature.name(), 0);
                        continue;
                    }
                    if (feature.isEnabled()) {
                        map.put(feature.name(), 1);
                        continue;
                    }
                    map.put(feature.name(), 0);
                }
                return map;
            }));
        }
    }

    public void onDisable() {
        TPEManager.saveTPE(Files.tportConfig);
        ColorTheme.saveThemes(Files.tportConfig);
        Redirect.Redirects.saveRedirects();
        Tag.saveTags();
        Auto.save();
        DynmapHandler.disable();
        try {
            BlueMapHandler.disable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PreviewEvents.cancelAllPreviews();
        for (Player player : Bukkit.getOnlinePlayers()) {
            QuickType.removeQuickTypeSignHandler(player);
            if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof FancyInventory)) continue;
            player.closeInventory();
            ColorTheme.sendInfoTranslation(player, "tport.Main.inventoryCloseByReload", new Object[0]);
        }
    }
}

