/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.UsageTracking;
import org.apache.commons.pool2.proxy.ProxySource;

public class ProxiedObjectPool<T>
implements ObjectPool<T> {
    private final ObjectPool<T> pool;
    private final ProxySource<T> proxySource;

    public ProxiedObjectPool(ObjectPool<T> objectPool, ProxySource<T> proxySource) {
        this.pool = objectPool;
        this.proxySource = proxySource;
    }

    @Override
    public void addObject() {
        this.pool.addObject();
    }

    @Override
    public T borrowObject() {
        UsageTracking usageTracking = null;
        if (this.pool instanceof UsageTracking) {
            usageTracking = (UsageTracking)((Object)this.pool);
        }
        return this.proxySource.createProxy(this.pool.borrowObject(), usageTracking);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public void invalidateObject(T t2) {
        this.pool.invalidateObject(this.proxySource.resolveProxy(t2));
    }

    @Override
    public void returnObject(T t2) {
        this.pool.returnObject(this.proxySource.resolveProxy(t2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProxiedObjectPool [pool=");
        stringBuilder.append(this.pool);
        stringBuilder.append(", proxySource=");
        stringBuilder.append(this.proxySource);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

