/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.UsageTracking;
import org.apache.commons.pool2.proxy.ProxySource;

public class ProxiedKeyedObjectPool<K, V>
implements KeyedObjectPool<K, V> {
    private final KeyedObjectPool<K, V> pool;
    private final ProxySource<V> proxySource;

    public ProxiedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, ProxySource<V> proxySource) {
        this.pool = keyedObjectPool;
        this.proxySource = proxySource;
    }

    @Override
    public void addObject(K k2) {
        this.pool.addObject(k2);
    }

    @Override
    public V borrowObject(K k2) {
        UsageTracking usageTracking = null;
        if (this.pool instanceof UsageTracking) {
            usageTracking = (UsageTracking)((Object)this.pool);
        }
        return this.proxySource.createProxy(this.pool.borrowObject(k2), usageTracking);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }

    @Override
    public void clear(K k2) {
        this.pool.clear(k2);
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getNumActive(K k2) {
        return this.pool.getNumActive(k2);
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumIdle(K k2) {
        return this.pool.getNumIdle(k2);
    }

    @Override
    public void invalidateObject(K k2, V v2) {
        this.pool.invalidateObject(k2, this.proxySource.resolveProxy(v2));
    }

    @Override
    public void returnObject(K k2, V v2) {
        this.pool.returnObject(k2, this.proxySource.resolveProxy(v2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProxiedKeyedObjectPool [pool=");
        stringBuilder.append(this.pool);
        stringBuilder.append(", proxySource=");
        stringBuilder.append(this.proxySource);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

