/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.commons.pool2.UsageTracking;
import org.apache.commons.pool2.proxy.JdkProxyHandler;
import org.apache.commons.pool2.proxy.ProxySource;

public class JdkProxySource<T>
implements ProxySource<T> {
    private final ClassLoader classLoader;
    private final Class<?>[] interfaces;

    public JdkProxySource(ClassLoader classLoader, Class<?>[] classArray) {
        this.classLoader = classLoader;
        this.interfaces = new Class[classArray.length];
        System.arraycopy(classArray, 0, this.interfaces, 0, classArray.length);
    }

    @Override
    public T createProxy(T t2, UsageTracking<T> usageTracking) {
        return (T)Proxy.newProxyInstance(this.classLoader, this.interfaces, new JdkProxyHandler<T>(t2, usageTracking));
    }

    @Override
    public T resolveProxy(T t2) {
        return ((JdkProxyHandler)Proxy.getInvocationHandler(t2)).disableProxy();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JdkProxySource [classLoader=");
        stringBuilder.append(this.classLoader);
        stringBuilder.append(", interfaces=");
        stringBuilder.append(Arrays.toString(this.interfaces));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

