/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.proxy;

import java.lang.reflect.Method;
import org.apache.commons.pool2.UsageTracking;

class BaseProxyHandler<T> {
    private volatile T pooledObject;
    private final UsageTracking<T> usageTracking;

    BaseProxyHandler(T t2, UsageTracking<T> usageTracking) {
        this.pooledObject = t2;
        this.usageTracking = usageTracking;
    }

    T disableProxy() {
        T t2 = this.pooledObject;
        this.pooledObject = null;
        return t2;
    }

    Object doInvoke(Method method, Object[] objectArray) {
        this.validateProxiedObject();
        T t2 = this.getPooledObject();
        if (this.usageTracking != null) {
            this.usageTracking.use(t2);
        }
        return method.invoke(t2, objectArray);
    }

    T getPooledObject() {
        return this.pooledObject;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [pooledObject=");
        stringBuilder.append(this.pooledObject);
        stringBuilder.append(", usageTracking=");
        stringBuilder.append(this.usageTracking);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    void validateProxiedObject() {
        if (this.pooledObject == null) {
            throw new IllegalStateException("This object may no longer be used as it has been returned to the Object Pool.");
        }
    }
}

