/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.ref.SoftReference;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class PooledSoftReference<T>
extends DefaultPooledObject<T> {
    private volatile SoftReference<T> reference;

    public PooledSoftReference(SoftReference<T> softReference) {
        super(null);
        this.reference = softReference;
    }

    @Override
    public T getObject() {
        return this.reference.get();
    }

    public synchronized SoftReference<T> getReference() {
        return this.reference;
    }

    public synchronized void setReference(SoftReference<T> softReference) {
        this.reference = softReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Referenced Object: ");
        stringBuilder.append(this.getObject().toString());
        stringBuilder.append(", State: ");
        PooledSoftReference pooledSoftReference = this;
        synchronized (pooledSoftReference) {
            stringBuilder.append(this.getState().toString());
        }
        return stringBuilder.toString();
    }
}

