/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.PooledObjectFactory;

class PoolImplUtils {
    PoolImplUtils() {
    }

    static Class<?> getFactoryType(Class<? extends PooledObjectFactory> clazz) {
        Class<PooledObjectFactory> clazz2 = PooledObjectFactory.class;
        Object object = PoolImplUtils.getGenericType(clazz2, clazz);
        if (object instanceof Integer) {
            Type type;
            Type[] typeArray;
            ParameterizedType parameterizedType = PoolImplUtils.getParameterizedType(clazz2, clazz);
            if (parameterizedType != null && (typeArray = ((TypeVariable)parameterizedType.getActualTypeArguments()[(Integer)object]).getBounds()) != null && typeArray.length > 0 && (type = typeArray[0]) instanceof Class) {
                return (Class)type;
            }
            return Object.class;
        }
        return (Class)object;
    }

    private static <T> Object getGenericType(Class<T> clazz, Class<? extends T> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        ParameterizedType parameterizedType = PoolImplUtils.getParameterizedType(clazz, clazz2);
        if (parameterizedType != null) {
            return PoolImplUtils.getTypeParameter(clazz2, parameterizedType.getActualTypeArguments()[0]);
        }
        Class<? extends T> clazz3 = clazz2.getSuperclass();
        Object object = PoolImplUtils.getGenericType(clazz, clazz3);
        if (object instanceof Class) {
            return object;
        }
        if (object instanceof Integer) {
            ParameterizedType parameterizedType2 = (ParameterizedType)clazz2.getGenericSuperclass();
            return PoolImplUtils.getTypeParameter(clazz2, parameterizedType2.getActualTypeArguments()[(Integer)object]);
        }
        return null;
    }

    private static <T> ParameterizedType getParameterizedType(Class<T> clazz, Class<? extends T> clazz2) {
        for (Type type : clazz2.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !clazz.isAssignableFrom((Class)parameterizedType.getRawType())) continue;
            return parameterizedType;
        }
        return null;
    }

    private static Object getTypeParameter(Class<?> clazz, Type type) {
        if (type instanceof Class) {
            return type;
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            if (!typeVariableArray[i2].equals(type)) continue;
            return i2;
        }
        return null;
    }

    static boolean isPositive(Duration duration) {
        return duration != null && !duration.isNegative() && !duration.isZero();
    }

    static Instant max(Instant instant, Instant instant2) {
        return instant.compareTo(instant2) > 0 ? instant : instant2;
    }

    static Instant min(Instant instant, Instant instant2) {
        return instant.compareTo(instant2) < 0 ? instant : instant2;
    }

    static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        switch (Objects.requireNonNull(timeUnit)) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException(timeUnit.toString());
    }

    static Duration nonNull(Duration duration, Duration duration2) {
        return duration != null ? duration : Objects.requireNonNull(duration2, "defaultValue");
    }

    static Duration toDuration(long l2, TimeUnit timeUnit) {
        return Duration.of(l2, PoolImplUtils.toChronoUnit(timeUnit));
    }
}

